package io.aether.utils.streams;

public class BufferNodeAutoFlush<TRead, TWrite> extends BufferNode<TRead, TWrite> {
    @Override
    public String toString() {
        return "BufferNodeAutoFlush";
    }

    @Override
    protected BGateUp initUp() {
        return new BFGateUp();
    }

    @Override
    protected BGateDown initDown() {
        return new BFGateDown();
    }

    public class BFGateUp extends BGateUp {
        @Override
        public void send(FGate<TWrite, TRead> fGate, Value<TWrite> value) {
            super.send(fGate, value.withForce());
        }
    }

    public class BFGateDown extends BGateDown {
        @Override
        public void send(FGate<TRead, TWrite> fGate, Value<TRead> value) {
            super.send(fGate, value.withForce());
        }
    }
}

