package io.aether.utils.streams;

import io.aether.utils.interfaces.ObjectFind;

/**
 * The Node interface represents a node in a bidirectional data structure,
 * which can interact with both the upper and lower levels.
 *
 * @param <Up_ToNode> Type of the node at the upper level
 * @param <Up_ToOut>  Type of output for the upper level
 * @param <Down_ToNode> Type of the node at the lower level
 * @param <Down_ToOut>  Type of output for the lower level
 */
public interface Node<Up_ToNode, Up_ToOut, Down_ToNode, Down_ToOut>
        extends
        NodeUp<Down_ToNode, Down_ToOut>,
        NodeDown<Up_ToNode, Up_ToOut>,
        ObjectFind {

}
