package io.aether.utils.streams;

import io.aether.utils.RU;
import io.aether.utils.futures.ARFuture;
import org.jetbrains.annotations.NotNull;

public abstract class NodeConverterAsync<TDown2, TUp2, TUp, TDown> implements Node<TDown2, TUp2, TUp, TDown> {

    protected abstract ARFuture<TDown> toDownConverter(TDown2 value);

    protected abstract ARFuture<TUp2> toUpConverter(TUp value);

    @Override
    public String toString() {
        return "async converter";
    }

    @Override
    public FGate<TDown2, TUp2> gUp() {
        return up;
    }

    @Override
    public FGate<TUp, TDown> gDown() {
        return down;
    }

    private final FGate<TUp, TDown> down = FGate.of(new FGate.Pair<TUp, TDown,TUp2>(this) {
        @Override
        public FGate<?, TUp2>.@NotNull InsideGate pair() {
            return up.inSide;
        }

        @Override
        public void send(FGate<TUp, TDown> fGate, Value<TUp> value) {
            if (value.data() == null) {
                pair().send(RU.cast(value));
                return;
            }
            var res = toUpConverter(value.data());
            if (res == null) {
                value.success(this);
            } else {
                res.to(v -> {
                    if (v == null) {
                        value.success(this);
                    } else {
                        pair().send(value.map2(v));
                    }
                });
            }
        }

    });
    private final FGate<TDown2, TUp2> up = FGate.of(new FGate.Pair<TDown2, TUp2,TDown>(this) {
        @Override
        public FGate<?, TDown>.@NotNull InsideGate pair() {
            return down.inSide;
        }

        @Override
        public void send(FGate<TDown2, TUp2> fGate, Value<TDown2> value) {
            if (!value.isData()) {
                pair().send(RU.cast(value));
                return;
            }
            var res = toDownConverter(value.data());
            if (res == null) {
                value.success(this);
            } else {
                res.to(v -> {
                    if (v == null) {
                        value.success(this);
                    } else {
                        pair().send(value.map2(v));
                    }
                });
            }
        }

    });


}
