package io.aether.utils.streams;

import io.aether.utils.AString;
import org.jetbrains.annotations.NotNull;

public abstract class NodeFilter<TDown, TUp>
        implements Node<TDown, TUp, TUp, TDown> {
    private final String name;
    public NodeFilter(String name) {
        this.name=name;
    }

    @Override
    public FGate<TDown, TUp> gUp() {
        return up;
    }

    @Override
    public FGate<TUp, TDown> gDown() {
        return down;
    }

    protected abstract boolean toDownFilter(TDown value);

    protected abstract boolean toUpFilter(TUp value);

    protected boolean toDownFilterValue(Value<TDown> value) {
        if (value.isData()) {
            return toDownFilter(value.data());
        }
        return true;
    }

    protected boolean toUpConverterValue(Value<TUp> value) {
        if (value.isData()) {
            return toUpFilter(value.data());
        }
        return true;
    }

    @Override
    public String toString() {
        return toString2();
    }

    @Override
    public void toString(AString sb) {
        sb.add("Node filter");
    }

    public String getName() {
        return name;
    }

    private final FGate<TDown, TUp> up =
            FGate.of(new FGate.Pair<TDown, TUp, TDown>(this) {
                @Override
                public void toString(AString sb) {
                    sb.add("filter ").add(getName()).add(" (up) -> ").add(pair());
                }

                @Override
                public FGate<?, TDown>.@NotNull InsideGate pair() {
                    return down.inSide;
                }

                @Override
                public void send(FGate<TDown, TUp> fGate, Value<TDown> value) {
                    if (toDownFilterValue(value)) {
                        pair().send(value);
                    }
                }

            });


    private final FGate<TUp, TDown> down = FGate.of(new FGate.Pair<TUp, TDown, TUp>(this) {
        @Override
        public void toString(AString sb) {
            sb.add("filter ").add(getName()).add(" (down) -> ").add(pair());
        }
        @Override
        public FGate<?, TUp>.@NotNull InsideGate pair() {
            return up.inSide;
        }

        @Override
        public void send(FGate<TUp, TDown> fGate, Value<TUp> value) {
            if (toUpConverterValue(value)) {
                pair().send(value);
            }
        }
    });


}
