package io.aether.utils.streams;

import io.aether.utils.RU;
import io.aether.utils.ToString;
import org.jetbrains.annotations.NotNull;

public interface NodeUp<Down_ToNode, Down_ToOut> extends ToString {
    FGate<Down_ToNode, Down_ToOut> gDown();

    default Gate<Down_ToNode, Down_ToOut> down() {
        return gDown().outSide();
    }

    @NotNull
    default <T> T findDown(Class<T> cryptoNodeClass) {
        if (cryptoNodeClass.isInstance(this)) return RU.cast(this);
        return gDown().inSide.find(cryptoNodeClass);
    }
}
