package io.aether.utils.streams;

import io.aether.utils.AString;
import io.aether.utils.ToString;
import io.aether.utils.interfaces.ABiConsumer;

public class OfBiConsumer<TRead, TOut> implements AcceptorI<TOut, TRead>, ToString {
    private final ABiConsumer<Value<TRead>, GateI<TOut>> consumer;
    private final String name;

    public OfBiConsumer(String name, ABiConsumer<Value<TRead>, GateI<TOut>> consumer) {
        this.consumer = consumer;
        this.name = name;
    }

    @Override
    public void toString(AString sb) {
        sb.add("GateBiConsumer(").add(name).add(":").add(consumer).add(")");
    }

    @Override
    public String toString() {
        return toString2();
    }

    @Override
    public void send(FGate<TRead, TOut> fGate, Value<TRead> value) {
        if (value.data() != null) {
            consumer.accept(value, fGate.inSide);
        }
    }

}
