package io.aether.utils.streams;

import io.aether.utils.AString;
import io.aether.utils.ToString;
import io.aether.utils.interfaces.AConsumer;

public class OfConsumer<TWrite, TRead> implements AcceptorI<TWrite, TRead>, ToString {
    private final AConsumer<TRead> consumer;
    private final String name;

    public OfConsumer(AConsumer<TRead> consumer, String name) {
        this.consumer = consumer;
        this.name = name;
    }

    @Override
    public void toString(AString sb) {
        sb.add("GateConsumer(").add(name).add(":").add(consumer).add(")");
    }

    @Override
    public String toString() {
        return toString2();
    }

    @Override
    public void send(FGate<TRead, TWrite> fGate, Value<TRead> value) {
        if (value.isData()) {
            consumer.accept(value.data());
        }
        value.success(this);
    }

}
