package io.aether.utils.streams;

import io.aether.utils.AString;
import io.aether.utils.interfaces.AFunction;

public class ValueMap<T2, T> implements Value<T2> {
    private final Value<T> self;
    private final AFunction<T, T2> mapper;
    volatile T2 cacheData;

    public ValueMap(Value<T> self, AFunction<T, T2> mapper) {
        this.self = self;
        this.mapper = mapper;
    }

    @Override
    public String toString() {
        return toString2();
    }

    @Override
    public void toString(AString sb) {
        sb.add("value(").add(data()).add(")");
    }

    @Override
    public void enter(Object owner) {
        self.enter(owner);
    }

    @Override
    public boolean isData() {
        return self.isData();
    }

    @Override
    public boolean isRequestData() {
        return self.isRequestData();
    }

    @Override
    public T2 data() {
        if (isData()) {
            if (cacheData == null) {
                cacheData = mapper.apply(self.data());
            }
            return cacheData;
        } else {
            return null;
        }
    }

    @Override
    public void reject(Object owner, long blockId) {
        self.reject(owner);
    }

    @Override
    public int priority() {
        return self.priority();
    }

    @Override
    public boolean isClose() {
        return self.isClose();
    }

    @Override
    public boolean isForce() {
        return self.isForce();
    }

    @Override
    public void success(Object owner) {
        self.success(owner);
    }

}
