package io.aether.utils.streams;

import io.aether.utils.AString;

public class ValueMap2<T, T2> implements Value<T> {
    private final Value<T2> self;
    private final T val;

    public ValueMap2(Value<T2> self, T val) {
        this.self = self;
        this.val = val;
    }

    @Override
    public String toString() {
        return toString2();
    }

    @Override
    public boolean isData() {
        return self.isData();
    }

    @Override
    public boolean isRequestData() {
        return self.isRequestData();
    }

    @Override
    public long getRequestDataId() {
        return self.getRequestDataId();
    }

    @Override
    public T data() {
        return val;
    }

    @Override
    public int priority() {
        return self.priority();
    }

    @Override
    public void enter(Object owner) {
        self.enter(owner);
    }

    @Override
    public boolean isForce() {
        return self.isForce();
    }

    @Override
    public boolean isClose() {
        return self.isClose();
    }

    @Override
    public void success(Object owner) {
        self.success(owner);
    }

    @Override
    public void reject(Object owner, long id) {
        self.reject(owner, id);
    }

    @Override
    public void toString(AString sb) {
        sb.add("value(").add(data()).add(")");
    }
}
