package io.aether.utils.streams;

import io.aether.utils.AString;
import io.aether.utils.interfaces.AConsumer;

public class ValueOfDataForceOnDrop<T> implements Value<T> {
    private final T data;
    private final AConsumer<Object> onDrop;
    private final boolean force;

    public ValueOfDataForceOnDrop(T data, AConsumer<Object> onDrop, boolean force) {
        this.data = data;
        this.onDrop = onDrop;
        this.force = force;
    }

    @Override
    public T data() {
        return data;
    }

    @Override
    public void enter(Object owner) {

    }

    @Override
    public boolean isData() {
        return true;
    }

    @Override
    public void success(Object owner) {
        onDrop.accept(owner);
    }

    @Override
    public boolean isForce() {
        return force;
    }

    @Override
    public void reject(Object owner, long blockId) {

    }

    @Override
    public String toString() {
        return toString2();
    }

    @Override
    public void toString(AString sb) {
        sb.addVars("value($data)", "data", data);
    }
}
