package io.aether.utils.streams;

public class ValueOnReject<T> extends ValueProxy<T> {
    public interface Listener {
        void accept(Object owner, long id);
    }

    private final Listener task;

    public ValueOnReject(Value<T> self, Listener task) {
        super(self);
        this.task = task;
    }


    @Override
    public void reject(Object owner, long blockId) {
        task.accept(owner, blockId);
        self.reject(owner, blockId);
    }
}
