package io.aether.utils.streams.safe;

import io.aether.utils.RU;
import io.aether.utils.streams.Gate;
import io.aether.utils.streams.Node4;
import io.aether.utils.streams.ThreadSafe;

public interface SafeNode<DownNode> extends Node4<byte[]>, ThreadSafe {
    static <DownNode> SafeNode<DownNode> of(Gate<byte[], byte[]> down) {
        var res= of();
        res.down().link(down);
        return RU.cast(res);
    }

    static <DownNode> SafeNode<DownNode> of() {
        var res = new SafeNodeImpl();
        return RU.cast(res);
    }

    static <DownNode> SafeNode<DownNode> ofCustom(int circleSize) {
        return RU.cast(new SafeNodeImpl(circleSize));
    }
    static <DownNode> SafeNode<DownNode> ofCustom(Gate<byte[], byte[]> down, int circleSize) {
        var res = new SafeNodeImpl(circleSize);
        res.down().link(down);
        return RU.cast(res);
    }

}
