/*
 * Decompiled with CFR 0.152.
 */
package io.aether.api.common;

import io.aether.api.common.AetherCodec;
import io.aether.common.NetworkConfigurator;
import io.aether.common.Protocol;
import io.aether.net.fastMeta.SerializerPackNumber;
import io.aether.net.serialization.DeserializerSizeStream;
import io.aether.utils.ConcurrentHashSet;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.streams.Value;
import java.net.URI;
import java.util.Collection;

public interface AetherCodecUtil {
    public static AetherCodec of(URI uri) {
        return AetherCodec.valueOf((String)uri.getScheme().toUpperCase());
    }

    public static NetworkConfigurator getNetworkConfigurator(URI uri) {
        return AetherCodecUtil.getNetworkConfigurator(AetherCodecUtil.of(uri));
    }

    public static NetworkConfigurator getNetworkConfigurator(AetherCodec codec) {
        switch (codec) {
            case TCP: {
                return new NetworkConfigurator(){

                    @Override
                    public Protocol initConnectionServer() {
                        return new ProtocolTCP();
                    }

                    @Override
                    public Protocol initConnectionClient(URI host) {
                        return new ProtocolTCP();
                    }

                    @Override
                    public String getName() {
                        return "tcp";
                    }
                };
            }
            case UDP: {
                return new NetworkConfigurator(){

                    @Override
                    public Protocol initConnectionServer() {
                        return new ProtocolUDP();
                    }

                    @Override
                    public Protocol initConnectionClient(URI host) {
                        return new ProtocolUDP();
                    }

                    @Override
                    public String getName() {
                        return "udp";
                    }
                };
            }
            case WEBSOCKET: {
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException();
    }

    public static class ProtocolTCP
    implements Protocol {
        final DeserializerSizeStream deserializerSizeStream = new DeserializerSizeStream();
        volatile DataInOutStatic pkg;
        private volatile Collection<Value<?>> values;

        @Override
        public void fromSocket(Value<byte[]> value, AConsumer<Value<byte[]>> result) {
            value.enter(this);
            if (value.isOnlyRequestData()) {
                result.accept(value);
                return;
            }
            assert (!value.isRequestData());
            if (value.isData()) {
                DataInOutStatic b = new DataInOutStatic(value.data());
                if (this.values == null) {
                    this.values = new ConcurrentHashSet();
                }
                this.values.add(value);
                while (b.isReadable()) {
                    if (this.pkg == null) {
                        if (!this.deserializerSizeStream.put((DataIn)b)) {
                            return;
                        }
                        int size = (int)this.deserializerSizeStream.getValue();
                        assert (size != 0);
                        this.pkg = new DataInOutStatic(new byte[size], 0, 0);
                        this.deserializerSizeStream.reset();
                    }
                    if (b.isReadable() && b.getSizeForRead() >= this.pkg.getSizeForWrite()) {
                        b.read(this.pkg.data, this.pkg.writePos, this.pkg.getSizeForWrite());
                        this.pkg.writePos = this.pkg.data.length;
                        DataInOutStatic p = this.pkg;
                        Collection<Value<?>> vv = this.values;
                        this.values = null;
                        this.pkg = null;
                        byte[] arr = p.toArray();
                        if (vv == null) {
                            result.accept(Value.of(arr));
                            continue;
                        }
                        result.accept(Value.of(arr, false, vv));
                        continue;
                    }
                    int s = b.getSizeForRead();
                    b.read(this.pkg.data, this.pkg.writePos, s);
                    this.pkg.writePos += s;
                }
            } else if (value.isForce() || value.isClose()) {
                result.accept(value);
            }
        }

        Value<byte[]> convert(Value<byte[]> value) {
            return value.map(d -> {
                DataInOutStatic b = new DataInOutStatic((byte[])value.data());
                int sizeHead = SerializerPackNumber.INSTANCE.calcSize((long)b.getSizeForRead());
                byte[] buf = new byte[sizeHead + b.getSizeForRead()];
                DataInOutStatic bb = new DataInOutStatic(buf);
                bb.setWritePos(0);
                SerializerPackNumber.INSTANCE.put((DataOut)bb, b.getSizeForRead());
                b.read(buf, sizeHead, b.getSizeForRead());
                return buf;
            });
        }

        @Override
        public void toSocket(Value<byte[]> value, AConsumer<Value<byte[]>> result) {
            value.enter(this);
            if (value.isData()) {
                if (value.data().length == 0) {
                    throw new IllegalStateException();
                }
                result.accept(this.convert(value));
            } else {
                result.accept(value);
            }
        }
    }

    public static class ProtocolUDP
    implements Protocol {
        @Override
        public void fromSocket(Value<byte[]> data, AConsumer<Value<byte[]>> result) {
            result.accept(data);
        }

        @Override
        public void toSocket(Value<byte[]> data, AConsumer<Value<byte[]>> result) {
            result.accept(data);
        }
    }
}

