/*
 * Decompiled with CFR 0.152.
 */
package io.aether.api.common;

import io.aether.api.common.Sign;
import io.aether.api.common.SignAE_ED25519;
import io.aether.api.common.SignHYDROGEN;
import io.aether.crypto.CryptoProviderFactory;

public interface SignUtil {
    public byte[] getData();

    public static io.aether.crypto.Sign of(Sign sign) {
        if (sign instanceof SignAE_ED25519) {
            return CryptoProviderFactory.getProvider("SODIUM").createSign(sign.getData());
        }
        if (sign instanceof SignHYDROGEN) {
            return CryptoProviderFactory.getProvider("HYDROGEN").createSign(sign.getData());
        }
        throw new UnsupportedOperationException();
    }

    public static Sign of(io.aether.crypto.Sign sign) {
        switch (sign.getProviderName().toLowerCase()) {
            case "sodium": {
                return new SignAE_ED25519(sign.getSignData());
            }
            case "hydrogen": {
                return new SignHYDROGEN(sign.getSignData());
            }
        }
        throw new UnsupportedOperationException();
    }
}

