/*
 * Decompiled with CFR 0.152.
 */
package io.aether.common;

import io.aether.common.AccessGroupMutable;
import io.aether.utils.futures.AFuture;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.rcollections.RCol;
import io.aether.utils.rcollections.RSet;
import io.aether.utils.slots.EventConsumer;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class AccessGroupListMutable {
    public final RSet<AccessGroupMutable> groups = RCol.set();
    private final EventConsumer<AccessGroupListMutable> onChange = new EventConsumer();
    private final AConsumer<UUID> onChangeListener = c -> this.onChange.fire((Object)this);

    public AccessGroupListMutable() {
        this.groups.forRemove().add(a -> {
            a.getGroup().forAdd().remove(this.onChangeListener);
            a.getGroup().forRemove().remove(this.onChangeListener);
            this.onChange.fire((Object)this);
        });
        this.groups.forAdd().add(a -> {
            a.getGroup().forAdd().add(this.onChangeListener);
            a.getGroup().forRemove().add(this.onChangeListener);
            this.onChange.fire((Object)this);
        });
    }

    public void add(AccessGroupMutable ag) {
        this.groups.add((Object)ag);
    }

    public boolean contains(UUID uid) {
        for (AccessGroupMutable g : this.groups) {
            if (!g.contains(uid)) continue;
            return true;
        }
        return false;
    }

    public AFuture containsFuture(UUID uid) {
        if (this.contains(uid)) {
            return AFuture.completed();
        }
        AFuture res = AFuture.make();
        AConsumer l = a -> {
            if (this.contains(uid)) {
                res.tryDone();
            }
        };
        res.addListener(f -> this.onChange.remove(l));
        this.onChange.add(l);
        return res;
    }

    public UUID[] allAsArray() {
        return this.all().toArray(new UUID[0]);
    }

    public long[] allGroupIdsAsArray() {
        LongArrayList l = new LongArrayList();
        for (AccessGroupMutable g : this.groups) {
            l.add(g.getId());
        }
        return l.toLongArray();
    }

    public Set<UUID> all() {
        HashSet<UUID> res = new HashSet<UUID>();
        for (AccessGroupMutable g : this.groups) {
            res.addAll((Collection<UUID>)g.getGroup());
        }
        return res;
    }

    public boolean remove(AccessGroupMutable gg) {
        return this.groups.removeIf(g -> g.id == gg.id);
    }
}

