/*
 * Decompiled with CFR 0.152.
 */
package io.aether.common.expressions;

import io.aether.common.expressions.Calculate;
import io.aether.common.expressions.Expression;
import io.aether.net.fastMeta.AetherException;
import io.aether.utils.RU;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.List;

public final class Invoke
extends Expression {
    byte cmdId;
    List<Expression> arguments;
    transient MethodHandle methodHandle;
    transient Method method;

    @Override
    protected void prepareForContext0() {
        this.method = this.ctx.methods[this.cmdId];
        this.methodHandle = this.ctx.methodHandles[this.cmdId];
        if (!this.method.isVarArgs() && this.arguments.size() != this.method.getParameterCount()) {
            throw new AetherException("Different argument count");
        }
        Class<?> t = this.method.getReturnType();
        if (t.isPrimitive()) {
            if (t == Byte.TYPE) {
                this.calculate = new Calculate(){

                    @Override
                    public Object calc() {
                        return this.calcByte();
                    }

                    @Override
                    public boolean calcBoolean() {
                        return this.calcByte() != 0;
                    }

                    @Override
                    public byte calcByte() {
                        Object[] args = new Object[Invoke.this.arguments.size()];
                        for (int i = 0; i < args.length; ++i) {
                            args[i] = Invoke.this.arguments.get((int)i).calculate.calc();
                        }
                        try {
                            return (Byte)Invoke.this.methodHandle.invokeWithArguments(args);
                        }
                        catch (Throwable e) {
                            return (Byte)RU.error((Throwable)e);
                        }
                    }

                    @Override
                    public short calcShort() {
                        return this.calcByte();
                    }

                    @Override
                    public int calcInt() {
                        return this.calcByte();
                    }

                    @Override
                    public long calcLong() {
                        return this.calcByte();
                    }

                    @Override
                    public double calcDouble() {
                        return this.calcByte();
                    }

                    @Override
                    public float calcFloat() {
                        return this.calcByte();
                    }
                };
            } else if (t == Short.TYPE) {
                this.calculate = new Calculate(){

                    @Override
                    public Object calc() {
                        return this.calcShort();
                    }

                    @Override
                    public boolean calcBoolean() {
                        return this.calcShort() != 0;
                    }

                    @Override
                    public byte calcByte() {
                        return (byte)this.calcShort();
                    }

                    @Override
                    public short calcShort() {
                        Object[] args = new Object[Invoke.this.arguments.size()];
                        for (int i = 0; i < args.length; ++i) {
                            args[i] = Invoke.this.arguments.get((int)i).calculate.calc();
                        }
                        try {
                            return (Short)Invoke.this.methodHandle.invokeWithArguments(args);
                        }
                        catch (Throwable e) {
                            return (Short)RU.error((Throwable)e);
                        }
                    }

                    @Override
                    public int calcInt() {
                        return this.calcShort();
                    }

                    @Override
                    public long calcLong() {
                        return this.calcShort();
                    }

                    @Override
                    public double calcDouble() {
                        return this.calcShort();
                    }

                    @Override
                    public float calcFloat() {
                        return this.calcShort();
                    }
                };
            } else if (t == Integer.TYPE) {
                this.calculate = new Calculate(){

                    @Override
                    public Object calc() {
                        return this.calcInt();
                    }

                    @Override
                    public boolean calcBoolean() {
                        return this.calcInt() != 0;
                    }

                    @Override
                    public byte calcByte() {
                        return (byte)this.calcInt();
                    }

                    @Override
                    public short calcShort() {
                        return (short)this.calcInt();
                    }

                    @Override
                    public int calcInt() {
                        Object[] args = new Object[Invoke.this.arguments.size()];
                        for (int i = 0; i < args.length; ++i) {
                            args[i] = Invoke.this.arguments.get((int)i).calculate.calc();
                        }
                        try {
                            return (Integer)Invoke.this.methodHandle.invokeWithArguments(args);
                        }
                        catch (Throwable e) {
                            return (Integer)RU.error((Throwable)e);
                        }
                    }

                    @Override
                    public long calcLong() {
                        return this.calcInt();
                    }

                    @Override
                    public double calcDouble() {
                        return this.calcInt();
                    }

                    @Override
                    public float calcFloat() {
                        return this.calcInt();
                    }
                };
            } else if (t == Long.TYPE) {
                this.calculate = new Calculate(){

                    @Override
                    public Object calc() {
                        return this.calcLong();
                    }

                    @Override
                    public boolean calcBoolean() {
                        return this.calcLong() != 0L;
                    }

                    @Override
                    public byte calcByte() {
                        return (byte)this.calcLong();
                    }

                    @Override
                    public short calcShort() {
                        return (short)this.calcLong();
                    }

                    @Override
                    public int calcInt() {
                        return (int)this.calcLong();
                    }

                    @Override
                    public long calcLong() {
                        Object[] args = new Object[Invoke.this.arguments.size()];
                        for (int i = 0; i < args.length; ++i) {
                            args[i] = Invoke.this.arguments.get((int)i).calculate.calc();
                        }
                        try {
                            return (Long)Invoke.this.methodHandle.invokeWithArguments(args);
                        }
                        catch (Throwable e) {
                            return (Long)RU.error((Throwable)e);
                        }
                    }

                    @Override
                    public double calcDouble() {
                        return this.calcLong();
                    }

                    @Override
                    public float calcFloat() {
                        return this.calcLong();
                    }
                };
            } else if (t == Float.TYPE) {
                this.calculate = new Calculate(){

                    @Override
                    public Object calc() {
                        return Float.valueOf(this.calcFloat());
                    }

                    @Override
                    public boolean calcBoolean() {
                        return this.calcFloat() != 0.0f;
                    }

                    @Override
                    public byte calcByte() {
                        return (byte)this.calcFloat();
                    }

                    @Override
                    public short calcShort() {
                        return (short)this.calcFloat();
                    }

                    @Override
                    public int calcInt() {
                        return (int)this.calcFloat();
                    }

                    @Override
                    public long calcLong() {
                        return (long)this.calcFloat();
                    }

                    @Override
                    public double calcDouble() {
                        return this.calcFloat();
                    }

                    @Override
                    public float calcFloat() {
                        Object[] args = new Object[Invoke.this.arguments.size()];
                        for (int i = 0; i < args.length; ++i) {
                            args[i] = Invoke.this.arguments.get((int)i).calculate.calc();
                        }
                        try {
                            return ((Float)Invoke.this.methodHandle.invokeWithArguments(args)).floatValue();
                        }
                        catch (Throwable e) {
                            return ((Float)RU.error((Throwable)e)).floatValue();
                        }
                    }
                };
            } else if (t == Double.TYPE) {
                this.calculate = new Calculate(){

                    @Override
                    public Object calc() {
                        return this.calcDouble();
                    }

                    @Override
                    public boolean calcBoolean() {
                        return this.calcDouble() != 0.0;
                    }

                    @Override
                    public byte calcByte() {
                        return (byte)this.calcDouble();
                    }

                    @Override
                    public short calcShort() {
                        return (short)this.calcDouble();
                    }

                    @Override
                    public int calcInt() {
                        return (int)this.calcDouble();
                    }

                    @Override
                    public long calcLong() {
                        return (long)this.calcDouble();
                    }

                    @Override
                    public double calcDouble() {
                        Object[] args = new Object[Invoke.this.arguments.size()];
                        for (int i = 0; i < args.length; ++i) {
                            args[i] = Invoke.this.arguments.get((int)i).calculate.calc();
                        }
                        try {
                            return (Double)Invoke.this.methodHandle.invokeWithArguments(args);
                        }
                        catch (Throwable e) {
                            return (Double)RU.error((Throwable)e);
                        }
                    }

                    @Override
                    public float calcFloat() {
                        return (float)this.calcDouble();
                    }
                };
            }
        } else {
            this.calculate = new Calculate(){

                @Override
                public Object calc() {
                    Object[] args = new Object[Invoke.this.arguments.size()];
                    for (int i = 0; i < args.length; ++i) {
                        args[i] = Invoke.this.arguments.get((int)i).calculate.calc();
                    }
                    try {
                        return Invoke.this.methodHandle.invokeWithArguments(args);
                    }
                    catch (Throwable e) {
                        return RU.error((Throwable)e);
                    }
                }

                @Override
                public boolean calcBoolean() {
                    Object o = this.calc();
                    if (o instanceof Boolean) {
                        return (Boolean)o;
                    }
                    if (o instanceof Number) {
                        return ((Number)o).intValue() != 0;
                    }
                    if (o instanceof String) {
                        return Boolean.parseBoolean((String)o);
                    }
                    return o != null;
                }

                @Override
                public byte calcByte() {
                    Object o = this.calc();
                    if (o instanceof Number) {
                        return ((Number)o).byteValue();
                    }
                    if (o instanceof String) {
                        return Byte.parseByte((String)o);
                    }
                    return 0;
                }

                @Override
                public short calcShort() {
                    Object o = this.calc();
                    if (o instanceof Number) {
                        return ((Number)o).shortValue();
                    }
                    if (o instanceof String) {
                        return Short.parseShort((String)o);
                    }
                    return 0;
                }

                @Override
                public int calcInt() {
                    Object o = this.calc();
                    if (o instanceof Number) {
                        return ((Number)o).intValue();
                    }
                    if (o instanceof String) {
                        return Integer.parseInt((String)o);
                    }
                    return 0;
                }

                @Override
                public long calcLong() {
                    Object o = this.calc();
                    if (o instanceof Number) {
                        return ((Number)o).longValue();
                    }
                    if (o instanceof String) {
                        return Long.parseLong((String)o);
                    }
                    return 0L;
                }

                @Override
                public double calcDouble() {
                    Object o = this.calc();
                    if (o instanceof Number) {
                        return ((Number)o).doubleValue();
                    }
                    if (o instanceof String) {
                        return Double.parseDouble((String)o);
                    }
                    return 0.0;
                }

                @Override
                public float calcFloat() {
                    Object o = this.calc();
                    if (o instanceof Number) {
                        return ((Number)o).floatValue();
                    }
                    if (o instanceof String) {
                        return Float.parseFloat((String)o);
                    }
                    return 0.0f;
                }
            };
        }
    }
}

