/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto;

import io.aether.crypto.AKey;
import io.aether.crypto.CryptoProvider;
import io.aether.crypto.CryptoProviderUnit;
import io.aether.crypto.Sign;
import io.aether.crypto.SignChecker;
import io.aether.crypto.Signer;

public class SignedKey
implements CryptoProviderUnit {
    public final AKey key;
    public final Sign sign;

    public SignedKey(AKey key, Signer signer) {
        this.key = key;
        this.sign = signer.sign(key.getData());
    }

    @Override
    public String getProviderName() {
        return this.key.getProviderName();
    }

    @Override
    public CryptoProvider getCryptoProvider() {
        return this.key.getCryptoProvider();
    }

    public SignedKey(AKey key, Sign sign) {
        assert (key != null);
        assert (sign != null);
        this.key = key;
        this.sign = sign;
    }

    public static SignedKey of(AKey key, Sign sign) {
        return new SignedKey(key, sign);
    }

    public AKey key() {
        return this.key;
    }

    public Sign sign() {
        return this.sign;
    }

    public boolean check(AKey.SignPublic signer) {
        return signer.toSignChecker().checkSign(this.key.getData(), this.sign);
    }

    public boolean check(SignChecker signChecker) {
        return signChecker.checkSign(this.key.getData(), this.sign);
    }

    public String toString() {
        return String.valueOf(this.key) + ":" + String.valueOf(this.sign);
    }
}

