/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.streams;

import io.aether.logger.Log;
import io.aether.utils.AString;
import io.aether.utils.CTypeI;
import io.aether.utils.ConcurrentPriorityQueue;
import io.aether.utils.RU;
import io.aether.utils.flow.Flow;
import io.aether.utils.interfaces.ObjectFind;
import io.aether.utils.streams.BlockMgr;
import io.aether.utils.streams.FGate;
import io.aether.utils.streams.Gate;
import io.aether.utils.streams.Node;
import io.aether.utils.streams.Value;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class BufferNode<TRead, TWrite>
implements Node<TWrite, TRead, TRead, TWrite>,
ObjectFind {
    private final FGate<TWrite, TRead> up = new FGate(this.initUp());
    private final FGate<TRead, TWrite> down = new FGate(this.initDown());

    public boolean isEmpty() {
        return this.isEmptyToUp() && this.isEmptyToDown();
    }

    public boolean isEmptyToUp() {
        return ((BGate)this.down.acceptor).getQueue().isEmpty();
    }

    public boolean isEmptyToDown() {
        return ((BGate)this.up.acceptor).getQueue().isEmpty();
    }

    public void toString(AString sb) {
        int s1 = -1;
        int s2 = -1;
        try {
            s1 = ((BGate)this.up.acceptor).getQueue().size();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s2 = ((BGate)this.down.acceptor).getQueue().size();
        }
        catch (Exception exception) {
            // empty catch block
        }
        sb.add("buffer(").add(s1).add(":").add(s2).add(")");
    }

    public String toString() {
        return this.toString2();
    }

    @Override
    public FGate<TWrite, TRead> gUp() {
        return this.up;
    }

    @Override
    public FGate<TRead, TWrite> gDown() {
        return this.down;
    }

    public void resumeUp() {
        ((BGate)this.up.acceptor).resume();
    }

    public void resumeDown() {
        ((BGate)this.down.acceptor).resume();
    }

    public void resume() {
        this.resumeUp();
        this.resumeDown();
    }

    public void pauseUp() {
        ((BGate)this.up.acceptor).pause();
    }

    public void pauseDown() {
        ((BGate)this.down.acceptor).pause();
    }

    public void pause() {
        this.pauseUp();
        this.pauseDown();
    }

    protected BGateUp initUp() {
        return new BGateUp();
    }

    protected BGateDown initDown() {
        return new BGateDown();
    }

    public static <TUp, TDown> BufferNode<TUp, TDown> of() {
        return new BufferNode();
    }

    public static <TUp, TDown> BufferNode<TUp, TDown> of(Gate<TDown, TUp> g) {
        BufferNode res = new BufferNode();
        res.down().link(g);
        return res;
    }

    public class BGateUp
    extends BGate<TWrite, TRead> {
        public BGateUp() {
            super(BufferNode.this);
        }

        @Override
        public void resume() {
            this.resume(BufferNode.this.up);
        }

        @Override
        public @NotNull FGate.InsideGate pair() {
            return BufferNode.this.gDown().inSide;
        }
    }

    public class BGateDown
    extends BGate<TRead, TWrite> {
        public BGateDown() {
            super(BufferNode.this);
        }

        @Override
        public void resume() {
            this.resume(BufferNode.this.down);
        }

        @Override
        public @NotNull FGate.InsideGate pair() {
            return BufferNode.this.gUp().inSide;
        }
    }

    public abstract class BGate<TIn, TOut>
    extends FGate.Pair<TIn, TOut, TIn> {
        protected final Queue<Value<TIn>> queue;
        volatile boolean pauseWrite;
        FGate<TIn, TOut> fGate;
        final BlockMgr blockMgr;

        public int countDataValues() {
            return Flow.flow(this.queue).filter(Value::isData).count();
        }

        public boolean isProcessing() {
            return !this.isPause() && !this.getQueue().isEmpty();
        }

        public BGate(Object owner) {
            super(owner);
            this.queue = new ConcurrentPriorityQueue((v1, v2) -> {
                int c = v1.priority() - v2.priority();
                if (c == 0) {
                    c = v1.hashCode() - v2.hashCode();
                }
                return c;
            });
            this.blockMgr = new BlockMgr();
        }

        @Override
        public <T1> T1 find(CTypeI<T1> type) {
            if (type.isInstance(this.owner)) {
                return (T1)RU.cast((Object)this.owner);
            }
            return super.find(type);
        }

        @Override
        public <T1> T1 find(Class<T1> type) {
            if (type.isInstance(this.owner)) {
                return (T1)RU.cast((Object)this.owner);
            }
            return super.find(type);
        }

        @Override
        public void setFGate(FGate<TIn, TOut> g) {
            this.fGate = g;
        }

        BGate<TOut, TIn> pairAcceptor() {
            return (BGate)RU.cast(this.pair().fGate.acceptor);
        }

        void flushTasks() {
            try {
                this.flushTasks0();
            }
            catch (Exception e) {
                Log.error((Throwable)e, (Object[])new Object[0]);
            }
        }

        private void flushTasks0() {
            try {
                Value<TIn> v;
                FGate.InsideGate g = this.pair();
                if (g.fGate.link == null) {
                    return;
                }
                AtomicBoolean stopFlag = new AtomicBoolean();
                while (!(this.isPause() || stopFlag.get() || this.blockMgr.isBlocked() || (v = this.queue.poll()) == null)) {
                    if (v.isRequestData()) {
                        assert (!v.isData());
                        BGate<TOut, TIn> pa = this.pairAcceptor();
                        if (!pa.blockMgr.unblock(v.getRequestDataId())) break;
                    }
                    g.send(v.linkOnRejectExclusive((o, id) -> {
                        Log.trace((String)"buffer: value is aborted $value (bid: $bid, owner: $owner)", (Object[])new Object[]{"owner", o, "bid", id, "value", v});
                        v.enter(BufferNode.this);
                        stopFlag.set(true);
                        this.queue.add(v);
                        if (!this.blockMgr.block(id)) {
                            this.flushTasks();
                        }
                    }));
                }
            }
            catch (Exception e) {
                Log.error((Throwable)e, (Object[])new Object[0]);
            }
        }

        public void pause() {
            this.pauseWrite = true;
        }

        public final boolean isPause() {
            return this.pauseWrite;
        }

        @Override
        public void send(FGate<TIn, TOut> fGate, Value<TIn> value) {
            if (value.isOnlyRequestData()) {
                this.requestDataPair(value);
                return;
            }
            if (value.isRequestData()) {
                this.requestDataPair(value.getRequestDataId());
            }
            this.queue.add(value);
            this.flushTasks();
        }

        public void requestDataPair(Value<TIn> r) {
            BGate<TOut, TIn> p = this.pairAcceptor();
            p.fGate.inSide.send(r);
            if (p.blockMgr.unblock(r.getRequestDataId())) {
                p.flushTasks();
            }
        }

        public void requestDataPair(long id) {
            this.requestDataPair(Value.ofRequest(id));
        }

        public abstract void resume();

        public void resume(FGate<TIn, TOut> g) {
            if (this.pauseWrite) {
                this.pauseWrite = false;
                this.flushTasks();
            }
            g.inSide.send(Value.ofRequest());
        }

        public Queue<Value<TIn>> getQueue() {
            return this.queue;
        }
    }
}

