/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.streams;

import io.aether.logger.Log;
import io.aether.utils.AString;
import io.aether.utils.CTypeI;
import io.aether.utils.ToString;
import io.aether.utils.interfaces.ObjectFind;
import io.aether.utils.streams.AcceptorI;
import io.aether.utils.streams.Gate;
import io.aether.utils.streams.GateI;
import io.aether.utils.streams.Value;
import java.lang.invoke.VarHandle;
import org.jetbrains.annotations.NotNull;

public class FGate<ToNode, ToOut> {
    private static final VarHandle LINK_UPDATER = CTypeI.of(FGate.class).getFieldVarHandle("link");
    public final AcceptorI<ToOut, ToNode> acceptor;
    public final InsideGate inSide = new InsideGate();
    private final OutSideGate outSide = new OutSideGate();
    public volatile Gate<ToOut, ToNode> link;

    public FGate(AcceptorI<ToOut, ToNode> acceptor) {
        this.acceptor = acceptor;
        acceptor.setFGate(this);
    }

    public String toString() {
        return this.inSide.toString();
    }

    public Gate<ToNode, ToOut> outSide() {
        return this.outSide;
    }

    public static <TIn, TOut> FGate<TIn, TOut> of(AcceptorI<TOut, TIn> acceptor) {
        return new FGate<TIn, TOut>(acceptor);
    }

    public static <TIn, TOut> FGate<TIn, TOut> of(Gate<TOut, TIn> link, AcceptorI<TOut, TIn> acceptor) {
        FGate<TIn, TOut> res = new FGate<TIn, TOut>(acceptor);
        res.outSide().link(link);
        return res;
    }

    public class InsideGate
    implements GateI<ToOut> {
        public final FGate<ToNode, ToOut> fGate;

        public InsideGate() {
            this.fGate = FGate.this;
        }

        public String toString() {
            Gate l = FGate.this.link;
            if (l != null) {
                return l.toString();
            }
            return "[NO LINK]";
        }

        public void toString(AString sb) {
            Gate l = FGate.this.link;
            if (l != null) {
                sb.add(l);
            } else {
                sb.add("[NO LINK]");
            }
        }

        public <T> T find(Class<T> type) {
            Gate l = FGate.this.link;
            if (l != null) {
                return (T)l.find(type);
            }
            return null;
        }

        public <T> T find(CTypeI<T> type) {
            Gate l = FGate.this.link;
            if (l != null) {
                return (T)l.find(type);
            }
            return null;
        }

        @Override
        public void send(Value<ToOut> value) {
            value.enter(this);
            Gate l = FGate.this.link;
            if (l != null) {
                try {
                    l.send(value);
                }
                catch (Exception e) {
                    Log.error((Throwable)e, (Object[])new Object[0]);
                    value.reject(this);
                }
            } else {
                value.reject(this);
            }
        }
    }

    public class OutSideGate
    implements Gate<ToNode, ToOut> {
        public FGate<ToNode, ToOut> getFGate() {
            return FGate.this;
        }

        public void toString(AString sb) {
            FGate.this.acceptor.toString(sb);
        }

        public String toString() {
            return this.toString2();
        }

        public <T> T find(Class<T> type) {
            return (T)FGate.this.acceptor.find(type);
        }

        public <T> T find(CTypeI<T> type) {
            return (T)FGate.this.acceptor.find(type);
        }

        @Override
        public void unlink() {
            OutSideGate l = (OutSideGate)FGate.this.link;
            if (l == null) {
                return;
            }
            LINK_UPDATER.compareAndSet(l.getFGate(), FGate.this.outSide, null);
            LINK_UPDATER.compareAndSet(this.getFGate(), l, null);
        }

        @Override
        public Gate<ToOut, ToNode> link() {
            return FGate.this.link;
        }

        @Override
        public void link0(Gate<ToOut, ToNode> g) {
            FGate.this.link = g;
        }

        @Override
        public void link(Gate<ToOut, ToNode> side) {
            OutSideGate old1 = (OutSideGate)FGate.this.link;
            if (old1 == side) {
                return;
            }
            FGate.this.link = side;
            side.link0(FGate.this.outSide);
            this.send(Value.ofRequest());
            side.send(Value.ofRequest());
        }

        @Override
        public void send(Value<ToNode> value) {
            value.enter(FGate.this.acceptor);
            FGate.this.acceptor.send(FGate.this, value);
        }
    }

    public static abstract class Pair<TIn, TOut, PairOut>
    implements AcceptorI<TOut, TIn>,
    ObjectFind {
        final Object owner;

        public Pair(Object owner) {
            this.owner = owner;
        }

        public String toString() {
            return String.valueOf(this.owner) + " -> " + String.valueOf(this.pair());
        }

        public void toString(AString sb) {
            sb.add(this.owner).add(" -> ").add((ToString)this.pair());
        }

        @NotNull
        public abstract InsideGate pair();

        public <T> T find(Class<T> type) {
            return this.pair().find(type);
        }

        public <T> T find(CTypeI<T> type) {
            return this.pair().find(type);
        }
    }
}

