/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.streams;

import io.aether.utils.ConcurrentHashSet;
import io.aether.utils.RU;
import io.aether.utils.flow.Flow;
import io.aether.utils.interfaces.ABiFunction;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.slots.AMFuture;
import io.aether.utils.streams.BlockMgr;
import io.aether.utils.streams.FGate;
import io.aether.utils.streams.Gate;
import io.aether.utils.streams.Switcher2;
import io.aether.utils.streams.Value;
import io.aether.utils.streams.ValueOfData;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class MapBase<K, V>
implements AConsumer<V> {
    private final MSwitcherOutput output = new MSwitcherOutput();
    private final MSwitcherInput input = new MSwitcherInput();
    final AtomicInteger futuresWithoutRequest = new AtomicInteger();
    private final ConcurrentHashMap<K, ARMultiFuture2<V>> cache = new ConcurrentHashMap();
    private final AFunction<V, K> keyGetter;
    private final ABiFunction<V, V, V> updater;
    boolean withLog;
    String logName;

    public MapBase(AFunction<V, K> keyGetter) {
        this(keyGetter, (v, v2) -> v2);
    }

    public MapBase(AFunction<V, K> keyGetter, ABiFunction<V, V, V> updater) {
        this.keyGetter = keyGetter;
        this.updater = updater;
    }

    public void refreshKey(K key) {
        this.cache.get(key).refresh();
    }

    public void refresh(V c) {
        Object key = this.keyGetter.apply(c);
        this.cache.get(key).refresh();
    }

    public Gate<K, V> addInputHard() {
        return this.input.linkUpHard();
    }

    public Gate<K, V> addInput() {
        return this.input.linkUp();
    }

    public Gate<K, V> addInputByRequestHard() {
        return this.addInputHard().distinctWrite("MapBase(" + this.logName + ") addInputByRequestHard");
    }

    public void accept2(V v) {
        this.set(v);
    }

    public void accept(V v) {
        this.set(v);
    }

    public void set(V val) {
        this.set0(this.keyGetter.apply(val), val);
    }

    public void setAll(Iterable<V> val) {
        for (V e : val) {
            this.set(e);
        }
    }

    public void set(K key, V val) {
        if (!this.keyGetter.apply(val).equals(key)) {
            throw new IllegalStateException();
        }
        this.set0(key, val);
    }

    protected void set0(K key, V val) {
        ARMultiFuture2 f = this.cache.computeIfAbsent(key, this::makeFuture);
        if (f.getNow() == null) {
            f.set(val);
        } else {
            f.set(this.updater.apply(f.getNow(), val));
            f.refresh();
        }
    }

    public MapBase<K, V> withLog() {
        this.withLog = true;
        return this;
    }

    public <K2, V2> MapBase<K2, V2> map(String name, AFunction<V, V2> valConverter1, AFunction<K2, K> keyConverter2, AFunction<V2, K2> keyConverter3) {
        MapBase<K2, V2> res = new MapBase<K2, V2>(keyConverter3).withLog(name);
        res.addSourceHard(this.addInputHard().map("MapBase (" + this.logName + "->" + name + ") remap", valConverter1, keyConverter2));
        return res;
    }

    public AMFuture<V> get(K key, AFunction<K, V> orCreate) {
        ARMultiFuture2 res = this.cache.computeIfAbsent(RU.cast(key), k -> {
            ARMultiFuture2<V> res2 = this.makeFuture(k);
            res2.set(orCreate.apply(k));
            return res2;
        });
        if (!res.isDone() && res.tryRequest()) {
            this.output.sendUp(Value.of(key));
        }
        return res;
    }

    private ARMultiFuture2<V> makeFuture(K k) {
        return new MyARMultiFuture2();
    }

    public AMFuture<V> get(K key) {
        final ARMultiFuture2 res = this.cache.computeIfAbsent(RU.cast(key), this::makeFuture);
        if (!res.isDone() && res.tryRequest()) {
            this.output.sendUp(new ValueOfData<K>(key){

                @Override
                public void reject(Object owner, long blockId) {
                    res.request.set(false);
                }
            });
        }
        return res;
    }

    public void flush() {
        for (Map.Entry<K, ARMultiFuture2<V>> e : this.cache.entrySet()) {
            if (e.getValue().isDone()) continue;
            this.output.sendUp(new ValueOfData<K>(e.getKey()){

                @Override
                public void reject(Object owner, long blockId) {
                }
            });
        }
        this.output.flushUp();
        this.input.flushUp();
    }

    public Flow<V> values() {
        return Flow.flow(this.cache.values()).map(AMFuture::getNow).filterNotNull();
    }

    public void addSource(Gate<K, V> src) {
        this.output.linkUp(src.buffer());
    }

    public void addSourceHard(Gate<K, V> src) {
        this.output.linkUpHard(src.buffer());
    }

    public Gate<V, K> addSourceHard() {
        return this.output.linkUpHard().buffer();
    }

    public MapBase<K, V> withLog(String logName) {
        this.logName = logName;
        return this.withLog();
    }

    private class MyARMultiFuture2
    extends ARMultiFuture2<V> {
        public MyARMultiFuture2() {
            super(MapBase.this.futuresWithoutRequest);
        }

        public boolean set(V value) {
            Object vv = this.value;
            if (vv == null) {
                if (UPDATER.compareAndSet(this, null, value)) {
                    this.eventConsumer.fire(value);
                    final BlockMgr blockMgr = new BlockMgr();
                    MapBase.this.input.sendUp(new ValueOfData<V>(value){

                        @Override
                        public void reject(Object owner, long blockId) {
                            if (!blockMgr.block(blockId)) {
                                MapBase.this.input.sendUp(this);
                            }
                        }
                    });
                    return true;
                }
                return this.set(value);
            }
            if (vv == value) {
                return false;
            }
            value = MapBase.this.updater.apply(vv, value);
            this.value = value;
            this.eventConsumer.fire(value);
            MapBase.this.input.sendUp(new ValueOfData<V>(value){

                @Override
                public void reject(Object owner, long blockId) {
                }
            });
            return true;
        }

        public void refresh() {
            super.refresh();
            Object v = this.getNow();
            if (v != null) {
                MapBase.this.input.sendUp(new ValueOfData<V>(v){

                    @Override
                    public void reject(Object owner, long blockId) {
                    }
                });
            }
        }
    }

    public static class ARMultiFuture2<T>
    extends AMFuture<T> {
        private final AtomicBoolean request = new AtomicBoolean(false);
        private final AtomicInteger futuresWithoutRequest;

        public ARMultiFuture2(AtomicInteger futuresWithoutRequest) {
            this.futuresWithoutRequest = futuresWithoutRequest;
        }

        public boolean tryRequest() {
            boolean res = this.request.compareAndSet(false, true);
            this.futuresWithoutRequest.decrementAndGet();
            return res;
        }
    }

    private class MSwitcherOutput
    extends Switcher2<K, V> {
        private MSwitcherOutput() {
        }

        @Override
        protected void onFirstRequest(Switcher2.SplitterUpGate sup, FGate<V, K> fGate, Value<V> value) {
            final SplitterUpGate2 s = (SplitterUpGate2)RU.cast((Object)sup);
            for (final Map.Entry e : MapBase.this.cache.entrySet()) {
                if (e.getValue().isDone() || !s.getOld().add(e.getKey())) continue;
                fGate.inSide.send(new ValueOfData<K>(e.getKey()){

                    @Override
                    public void reject(Object owner, long blockId) {
                        s.getOld().remove(e.getKey());
                    }
                });
            }
        }

        @Override
        public Gate<V, K> linkUpHard() {
            FGate gInner = FGate.of(new SplitterUpGateHard2());
            return gInner.outSide();
        }

        @Override
        public Gate<V, K> linkUp() {
            FGate gInner = FGate.of(new SplitterUpGateSoft2());
            return gInner.outSide();
        }

        @Override
        protected void sendToDown2(Switcher2.SplitterUpGate sup, FGate<V, K> fGate, Value<V> value) {
            if (value.isRequestData()) {
                for (Map.Entry e : MapBase.this.cache.entrySet()) {
                    if (MapBase.this.output.blockMgrGlobal.isBlocked() || e.getValue().isDone() || !e.getValue().tryRequest()) continue;
                    fGate.inSide.send(Value.of(e.getKey()).onReject((owner, id) -> {
                        if (!((ARMultiFuture2)((Object)((Object)e.getValue()))).isDone()) {
                            ((ARMultiFuture2)((Object)((Object)e.getValue()))).request.set(false);
                        }
                    }));
                }
            }
            if (value.isData()) {
                MapBase.this.set(value.data());
            }
            value.success(MapBase.this);
        }

        @Override
        protected void sendUp(Value<K> value, FGate<V, K> g, AtomicInteger abortCounter, AtomicBoolean finalFlag) {
            SplitterUpGate2 sup = (SplitterUpGate2)RU.cast(g.acceptor);
            if (value.isData() && !sup.getOld().add(value.data())) {
                return;
            }
            super.sendUp(value, g, abortCounter, finalFlag);
        }

        class SplitterUpGateHard2
        extends Switcher2.SplitterUpGateHard
        implements SplitterUpGate2<K> {
            final Set<K> old;

            SplitterUpGateHard2() {
                super(MSwitcherOutput.this);
                this.old = new ConcurrentHashSet();
            }

            @Override
            public Set<K> getOld() {
                return this.old;
            }
        }

        class SplitterUpGateSoft2
        extends Switcher2.SplitterUpGateSoft
        implements SplitterUpGate2<K> {
            final Set<K> old;

            SplitterUpGateSoft2() {
                super(MSwitcherOutput.this);
                this.old = new ConcurrentHashSet();
            }

            @Override
            public Set<K> getOld() {
                return this.old;
            }
        }
    }

    private class MSwitcherInput
    extends Switcher2<V, K> {
        private MSwitcherInput() {
        }

        @Override
        public Gate<K, V> linkUpHard() {
            FGate gInner = FGate.of(new SplitterUpGateHard2());
            return gInner.outSide();
        }

        @Override
        public Gate<K, V> linkUp() {
            FGate gInner = FGate.of(new SplitterUpGateSoft2());
            return gInner.outSide();
        }

        @Override
        protected void sendToDown2(Switcher2.SplitterUpGate sup, FGate<K, V> fGate, Value<K> value) {
            Object key;
            AMFuture f;
            SplitterUpGate2 s = (SplitterUpGate2)RU.cast((Object)sup);
            if (value.isData() && (f = MapBase.this.get(key = value.data())).isDone() && s.getOld().add(key)) {
                fGate.inSide.send(Value.of(f.getNow()).onReject((o, id) -> s.getOld().remove(key)));
            }
        }

        @Override
        protected void onFirstRequest(Switcher2.SplitterUpGate sup, FGate<K, V> fGate, Value<K> value) {
            final SplitterUpGate2 s = (SplitterUpGate2)RU.cast((Object)sup);
            for (final Map.Entry e : MapBase.this.cache.entrySet()) {
                if (!e.getValue().isDone() || !s.getOld().add(e.getKey())) continue;
                fGate.inSide.send(new ValueOfData<V>(e.getValue().getNow()){

                    @Override
                    public void reject(Object owner, long blockId) {
                        s.getOld().remove(e.getKey());
                    }
                });
            }
        }

        @Override
        protected void sendUp(Value<V> value, FGate<K, V> g, AtomicInteger abortCounter, AtomicBoolean finalFlag) {
            SplitterUpGate2 sup = (SplitterUpGate2)RU.cast(g.acceptor);
            if (value.isData()) {
                Object key = MapBase.this.keyGetter.apply(value.data());
                if (!sup.getOld().add(key)) {
                    return;
                }
            }
            super.sendUp(value, g, abortCounter, finalFlag);
        }

        class SplitterUpGateHard2
        extends Switcher2.SplitterUpGateHard
        implements SplitterUpGate2<K> {
            final Set<K> old;

            SplitterUpGateHard2() {
                super(MSwitcherInput.this);
                this.old = new ConcurrentHashSet();
            }

            @Override
            public Set<K> getOld() {
                return this.old;
            }
        }

        class SplitterUpGateSoft2
        extends Switcher2.SplitterUpGateSoft
        implements SplitterUpGate2<K> {
            final Set<K> old;

            SplitterUpGateSoft2() {
                super(MSwitcherInput.this);
                this.old = new ConcurrentHashSet();
            }

            @Override
            public Set<K> getOld() {
                return this.old;
            }
        }
    }

    private static interface SplitterUpGate2<KK> {
        public Set<KK> getOld();
    }
}

