/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.streams;

import io.aether.utils.AString;
import io.aether.utils.ToString;
import io.aether.utils.streams.FGate;
import io.aether.utils.streams.Node;
import io.aether.utils.streams.Value;
import org.jetbrains.annotations.NotNull;

public abstract class NodeFilter<TDown, TUp>
implements Node<TDown, TUp, TUp, TDown> {
    private final String name;
    private final FGate<TDown, TUp> up = FGate.of(new FGate.Pair<TDown, TUp, TDown>(this){

        @Override
        public void toString(AString sb) {
            sb.add("filter ").add(NodeFilter.this.getName()).add(" (up) -> ").add((ToString)this.pair());
        }

        @Override
        public @NotNull FGate.InsideGate pair() {
            return NodeFilter.this.down.inSide;
        }

        @Override
        public void send(FGate<TDown, TUp> fGate, Value<TDown> value) {
            if (NodeFilter.this.toDownFilterValue(value)) {
                this.pair().send(value);
            }
        }
    });
    private final FGate<TUp, TDown> down = FGate.of(new FGate.Pair<TUp, TDown, TUp>(this){

        @Override
        public void toString(AString sb) {
            sb.add("filter ").add(NodeFilter.this.getName()).add(" (down) -> ").add((ToString)this.pair());
        }

        @Override
        public @NotNull FGate.InsideGate pair() {
            return NodeFilter.this.up.inSide;
        }

        @Override
        public void send(FGate<TUp, TDown> fGate, Value<TUp> value) {
            if (NodeFilter.this.toUpConverterValue(value)) {
                this.pair().send(value);
            }
        }
    });

    public NodeFilter(String name) {
        this.name = name;
    }

    @Override
    public FGate<TDown, TUp> gUp() {
        return this.up;
    }

    @Override
    public FGate<TUp, TDown> gDown() {
        return this.down;
    }

    protected abstract boolean toDownFilter(TDown var1);

    protected abstract boolean toUpFilter(TUp var1);

    protected boolean toDownFilterValue(Value<TDown> value) {
        if (value.isData()) {
            return this.toDownFilter(value.data());
        }
        return true;
    }

    protected boolean toUpConverterValue(Value<TUp> value) {
        if (value.isData()) {
            return this.toUpFilter(value.data());
        }
        return true;
    }

    public String toString() {
        return this.toString2();
    }

    public void toString(AString sb) {
        sb.add("Node filter");
    }

    public String getName() {
        return this.name;
    }
}

