/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.streams;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.utils.RU;
import io.aether.utils.ToString;
import io.aether.utils.futures.AFuture;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.streams.ValueAddRequest;
import io.aether.utils.streams.ValueClose;
import io.aether.utils.streams.ValueExclusiveOnReject;
import io.aether.utils.streams.ValueForce;
import io.aether.utils.streams.ValueMap;
import io.aether.utils.streams.ValueMap2;
import io.aether.utils.streams.ValueNotClose;
import io.aether.utils.streams.ValueOfData;
import io.aether.utils.streams.ValueOfDataForceOnDrop;
import io.aether.utils.streams.ValueOfForce;
import io.aether.utils.streams.ValueOfForceOnDrop;
import io.aether.utils.streams.ValueOfOnDrop;
import io.aether.utils.streams.ValueOfRequest;
import io.aether.utils.streams.ValueOnDrop;
import io.aether.utils.streams.ValueOnEnter;
import io.aether.utils.streams.ValueOnReject;
import io.aether.utils.streams.ValueProxy;
import io.aether.utils.streams.ValueProxyTimeout;
import io.aether.utils.streams.ValueWithClose;
import io.aether.utils.streams.ValueWithForce;
import io.aether.utils.streams.ValueWithSubValues;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public interface Value<T>
extends ToString {
    public static final AtomicLong BLOCK_COUNTER = new AtomicLong();
    public static final Value<?> FORCE_INSTANCE = new ValueForce();
    public static final Value<?> CLOSE_INSTANCE = new ValueClose();
    public static final long TIMEOUT = 800000L;

    public T data();

    default public int priority() {
        return 0;
    }

    default public boolean isForce() {
        return false;
    }

    default public boolean isRequestData() {
        return false;
    }

    default public long getRequestDataId() {
        return 0L;
    }

    default public boolean isClose() {
        return false;
    }

    public void success(Object var1);

    public void enter(Object var1);

    public void reject(Object var1, long var2);

    default public void reject(Object owner) {
        this.reject(owner, BLOCK_COUNTER.incrementAndGet());
    }

    default public Value<T> timeout(long time) {
        return new ValueProxyTimeout(this, time);
    }

    default public Value<T> timeout(long time, AConsumer<ConcurrentLinkedQueue<Object>> task) {
        ConcurrentLinkedQueue lastEnter = new ConcurrentLinkedQueue();
        Value self = this;
        ScheduledFuture sch = RU.schedule((long)time, () -> {
            Log.warn((String)"timeout value completed [$enter]", (Object[])new Object[]{"enter", lastEnter, "value", self});
            task.accept((Object)lastEnter);
        });
        return this.onReject((o, id) -> sch.cancel(false)).onEnter((AConsumer<Object>)((AConsumer)lastEnter::add)).onSuccess((AConsumer<Object>)((AConsumer)o -> sch.cancel(false)));
    }

    default public Value<T> onEnter(AConsumer<Object> f) {
        Value self = this;
        return new ValueOnEnter(self, f);
    }

    default public <T2> Value<T2> map2(T2 val) {
        Value self = this;
        return new ValueMap2(self, val);
    }

    default public <T2> Value<T2> map(AFunction<T, T2> mapper) {
        Value self = this;
        return new ValueMap<T2, T>(self, mapper);
    }

    default public Value<T> linkOnRejectExclusive(ValueExclusiveOnReject.Listener task) {
        Value self = this;
        return new ValueExclusiveOnReject(self, task);
    }

    default public Value<T> onReject(ValueOnReject.Listener task) {
        Value self = this;
        LNode l = Log.get();
        return new ValueOnReject(self, (o, id) -> {
            Log.push((LNode)l);
            try {
                task.accept(o, id);
            }
            finally {
                Log.pop((LNode)l);
            }
        });
    }

    default public Value<T> onSuccess(AConsumer<Object> task) {
        Value self = this;
        return new ValueOnDrop(self, (AConsumer<Object>)Log.wrap(task));
    }

    public boolean isData();

    default public Value<T> withForce() {
        if (this.isForce()) {
            return this;
        }
        Value self = this;
        return new ValueWithForce(self);
    }

    default public Value<T> withClose() {
        if (this.isClose()) {
            return this;
        }
        Value self = this;
        return new ValueWithClose(self);
    }

    default public Value<T> notClose() {
        if (!this.isClose()) {
            return this;
        }
        Value self = this;
        return new ValueNotClose(self);
    }

    @NotNull
    default public Value<T> addRequest() {
        Value self = this;
        return new ValueAddRequest(self);
    }

    default public boolean isOnlyRequestData() {
        return this.isRequestData() && !this.isData() && !this.isClose() && !this.isForce();
    }

    default public Value<T> linkFuture(final AFuture res) {
        return new ValueProxy<T>(this){

            @Override
            public void success(Object owner) {
                res.done();
                super.success(owner);
            }

            @Override
            public void reject(Object owner) {
                res.cancel();
                super.reject(owner);
            }
        };
    }

    public static <T> Value<T> of(T data, boolean force, Collection<Value<?>> subValues) {
        return new ValueWithSubValues<T>(data, force, subValues).timeout(800000L);
    }

    public static <T> Value<T> of(T data) {
        return new ValueOfData<T>(data).timeout(800000L);
    }

    public static <T> Value<T> ofForce(T data) {
        return new ValueOfForce<T>(data).timeout(800000L);
    }

    public static <T> Value<T> of(T data, AConsumer<Object> onDrop) {
        return new ValueOfOnDrop<T>(data, onDrop).timeout(800000L);
    }

    public static <T> Value<T> of(T data, boolean force, AConsumer<Object> onDrop) {
        return new ValueOfDataForceOnDrop<T>(data, onDrop, force).timeout(800000L);
    }

    public static <T> Value<T> ofForce(T data, AConsumer<Object> onDrop) {
        return new ValueOfForceOnDrop<T>(data, onDrop).timeout(800000L);
    }

    public static <K> Value<K> ofForce() {
        return (Value)RU.cast(FORCE_INSTANCE);
    }

    @NotNull
    public static <T> Value<T> ofRequest() {
        return Value.ofRequest(BLOCK_COUNTER.incrementAndGet());
    }

    @NotNull
    public static <T> Value<T> ofRequest(long id) {
        return new ValueOfRequest(id);
    }

    public static <T> Value<T> ofClose() {
        return (Value)RU.cast(CLOSE_INSTANCE);
    }
}

