/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.streams;

import io.aether.utils.AString;
import io.aether.utils.streams.Value;
import java.util.Collection;

public class ValueWithSubValues<T>
implements Value<T> {
    private final T data;
    private final boolean force;
    private final Collection<Value<?>> subValues;

    public ValueWithSubValues(T data, boolean force, Collection<Value<?>> subValues) {
        this.data = data;
        this.force = force;
        this.subValues = subValues;
    }

    @Override
    public T data() {
        return this.data;
    }

    @Override
    public void enter(Object owner) {
        for (Value<?> e : this.subValues) {
            e.enter(owner);
        }
    }

    @Override
    public boolean isData() {
        return true;
    }

    @Override
    public void reject(Object owner, long blockId) {
        for (Value<?> e : this.subValues) {
            e.reject(owner);
        }
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public void success(Object owner) {
        for (Value<?> v : this.subValues) {
            v.success(owner);
        }
    }

    public String toString() {
        return this.toString2();
    }

    public void toString(AString sb) {
        sb.addVars((CharSequence)"value($force:$data)", new Object[]{"data", this.data, "force", this.force});
    }
}

