/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.streams.safe;

import io.aether.net.fastMeta.Command;
import io.aether.net.fastMeta.FastApiContext;
import io.aether.utils.AString;
import io.aether.utils.AutoRun;
import io.aether.utils.futures.AFuture;
import io.aether.utils.streams.FGate;
import io.aether.utils.streams.Value;
import io.aether.utils.streams.safe.SafeNode;
import java.util.Arrays;
import java.util.Deque;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jetbrains.annotations.NotNull;

public class SafeNodeImpl
implements SafeNode<Object> {
    public final InStreamApi inStreamApi = new InStreamApi();
    private final int circleSize;
    private final int windowSize;
    private final UpGate upWorker = new UpGate();
    private final FastApiContext con;
    private final FGate<byte[], byte[]> down;
    private final AutoRun.Multi autoWork;
    private final AutoRun.Multi.Task autoFlush;
    private final AutoRun.Multi.Task autoStatus;
    private boolean needSendStatus;
    final FGate<byte[], byte[]> up = FGate.of(new FGate.Pair<byte[], byte[], byte[]>((Object)this){

        @Override
        public @NotNull FGate.InsideGate pair() {
            return SafeNodeImpl.this.down.inSide;
        }

        @Override
        public void send(FGate<byte[], byte[]> fGate, Value<byte[]> value) {
            SafeNodeImpl.this.upWorker.send(value);
        }
    });
    private int repeatCounter = 0;

    public SafeNodeImpl() {
        this(65535);
    }

    public SafeNodeImpl(int circleSize) {
        this.circleSize = circleSize;
        this.windowSize = circleSize / 2;
        this.con = new FastApiContext(){

            public void flush(AFuture sendFuture) {
                throw new UnsupportedOperationException();
            }
        };
        this.down = null;
        this.autoWork = new AutoRun.Multi(Runnable::run);
        this.autoFlush = new AutoRun.Multi.Task(this.autoWork){

            public void work() {
                SafeNodeImpl.this.downFlush();
            }
        };
        this.autoStatus = new AutoRun.Multi.Task(this.autoWork){
            {
                this.setTimeout(10L);
            }

            public void work() {
                SafeNodeImpl.this.needSendStatus = true;
                SafeNodeImpl.this.autoFlush.needWork();
            }
        };
    }

    public void toString(AString sb) {
        sb.add("SafeStream");
    }

    private void sendStatus() {
        this.needSendStatus = false;
        this.autoStatus.refreshNeedWork();
    }

    public void confirmToRemote(int remoteEnd) {
        InStreamApi l = this.getLocalApi();
        if (l.begin != l.end) {
            int off = l.begin;
            for (RecIn e : l.bufferIn) {
                if (e.offset > off) {
                    int n = off;
                }
                off = e.end();
            }
            if (l.end != remoteEnd) {
                // empty if block
            }
            this.autoFlush.needWork();
        }
        this.autoFlush.needWork();
    }

    @Override
    public FGate<byte[], byte[]> gUp() {
        return this.up;
    }

    @Override
    public FGate<byte[], byte[]> gDown() {
        return this.down;
    }

    private int convert(int value) {
        return value % this.circleSize;
    }

    private short convertShort(int value) {
        return (short)this.convert(value);
    }

    private InStreamApi getLocalApi() {
        return this.inStreamApi;
    }

    private void downFlush() {
        this.upWorker.flush();
        if (this.needSendStatus) {
            this.sendStatus();
        }
    }

    protected class UpGate {
        final Deque<Value<byte[]>> buffer = new ConcurrentLinkedDeque<Value<byte[]>>();
        final Deque<Value<byte[]>> buffer2 = new ConcurrentLinkedDeque<Value<byte[]>>();
        int begin;
        int beginSend;
        int end;

        protected UpGate() {
        }

        public boolean isWritable() {
            return this.end - this.begin > SafeNodeImpl.this.windowSize;
        }

        public boolean send(Value<byte[]> value) {
            assert (value.data().length <= SafeNodeImpl.this.windowSize) : value.data().length;
            if (this.end - this.begin + value.data().length > SafeNodeImpl.this.windowSize) {
                SafeNodeImpl.this.needSendStatus = true;
                SafeNodeImpl.this.downFlush();
                return false;
            }
            this.buffer.add(value);
            this.buffer2.add(value);
            this.end += value.data().length;
            this.flushToDown();
            SafeNodeImpl.this.autoFlush.refreshNeedWork();
            return true;
        }

        public void flush() {
            this.flushToDown();
            this.correctRanges();
            SafeNodeImpl.this.autoFlush.needWork();
        }

        private void flushToDown() {
            Value<byte[]> v;
            this.correctRanges();
            while ((v = this.buffer2.poll()) != null) {
                this.beginSend = (this.beginSend + v.data().length) % SafeNodeImpl.this.circleSize;
            }
            if (this.end - this.begin == SafeNodeImpl.this.windowSize) {
                this.correctRanges();
            } else {
                SafeNodeImpl.this.autoFlush.needWork();
            }
        }

        private void correctRanges() {
            if (this.begin >= SafeNodeImpl.this.circleSize) {
                this.begin %= SafeNodeImpl.this.circleSize;
                this.end %= SafeNodeImpl.this.circleSize;
            }
        }

        private int convertOffsetToLocal(int offset) {
            if (this.end % SafeNodeImpl.this.circleSize < this.begin % SafeNodeImpl.this.circleSize) {
                if (offset < this.begin) {
                    offset += SafeNodeImpl.this.circleSize * (this.end / SafeNodeImpl.this.circleSize);
                }
            } else {
                this.correctRanges();
            }
            return offset;
        }

        public void confirmRemoteReceive(int offset) {
            Value<byte[]> ar;
            if ((offset = this.convertOffsetToLocal(offset)) <= this.begin || offset > this.end) {
                return;
            }
            for (int skipOffset = offset - this.begin; skipOffset > 0; skipOffset -= ar.data().length) {
                ar = this.buffer.removeFirst();
                if (ar.data().length < skipOffset) {
                    continue;
                }
                if (skipOffset == ar.data().length) break;
                byte[] ar2 = Arrays.copyOfRange(ar.data(), skipOffset, ar.data().length);
                this.buffer.addFirst(ar.map2(ar2));
                break;
            }
            this.begin = offset;
            this.correctRanges();
            SafeNodeImpl.this.up.inSide.send(Value.ofRequest());
        }

        public void repeatAfter(int offset) {
            if ((offset = this.convertOffsetToLocal(offset)) < this.begin || offset >= this.end) {
                return;
            }
            int offset2 = this.begin;
            short repId = (short)SafeNodeImpl.this.repeatCounter++;
            for (Value<byte[]> ar : this.buffer) {
                int step = offset2 + ar.data().length;
                if (step > offset) {
                    int arBegin = offset - offset2;
                    int finalOffset = offset;
                    offset = step;
                }
                offset2 = step;
            }
        }

        public void repeat(int offset, int length) {
            SafeNodeImpl.this.autoFlush.refreshNeedWork();
            offset = this.convertOffsetToLocal(offset);
            if (offset < this.begin || offset > this.end) {
                return;
            }
            short repId = (short)SafeNodeImpl.this.repeatCounter++;
            int offset2 = this.begin;
            for (Value<byte[]> ar : this.buffer) {
                int step = offset2 + ar.data().length;
                if (step > offset) {
                    int arBegin;
                    int finalOffset = offset;
                    if (ar.data().length == length) break;
                    if (ar.data().length < length) {
                        arBegin = offset - offset2;
                        offset = step;
                        length -= ar.data().length - arBegin;
                    } else {
                        arBegin = offset - offset2;
                        int finalLength = length;
                        break;
                    }
                }
                offset2 = step;
            }
        }

        public int getSizeForWrite() {
            return SafeNodeImpl.this.windowSize - (this.end - this.begin);
        }
    }

    public class InStreamApi
    implements SafeStreamApi {
        final SortedSet<RecIn> bufferIn = new TreeSet<RecIn>();
        int begin;
        int end;

        @Override
        public void requestRepeatInt(int offset, int length) {
            SafeNodeImpl.this.upWorker.repeat(offset, length);
        }

        @Override
        public void status(short send, short receive) {
            this.statusInt(Short.toUnsignedInt(send), Short.toUnsignedInt(receive));
        }

        @Override
        public void statusInt(int send, int receive) {
            if ((send = this.convertOffsetToLocal(send)) != this.end) {
                int off = this.begin;
                for (RecIn e : this.bufferIn) {
                    if (e.offset > off) {
                        int n = off;
                    }
                    off = e.end();
                }
            }
            SafeNodeImpl.this.upWorker.confirmRemoteReceive(receive);
            SafeNodeImpl.this.needSendStatus = true;
            SafeNodeImpl.this.autoFlush.needWork();
        }

        @Override
        public void close() {
        }

        @Override
        public void requestRepeat(short offset, short length) {
            this.requestRepeatInt(Short.toUnsignedInt(offset), Short.toUnsignedInt(length));
        }

        @Override
        public void send(short offset, byte[] data) {
            this.sendInt(Short.toUnsignedInt(offset), data);
        }

        @Override
        public void requestRepeatAfter(short offset) {
            this.requestRepeatAfterInt(Short.toUnsignedInt(offset));
        }

        @Override
        public void requestRepeatAfterInt(int offset) {
            SafeNodeImpl.this.upWorker.repeatAfter(offset);
        }

        private int convertOffsetToLocal(int offset) {
            if (this.end % SafeNodeImpl.this.circleSize < this.begin % SafeNodeImpl.this.circleSize) {
                if (offset < this.begin) {
                    offset += SafeNodeImpl.this.circleSize * (this.end / SafeNodeImpl.this.circleSize);
                }
            } else if (this.begin >= SafeNodeImpl.this.circleSize) {
                this.begin %= SafeNodeImpl.this.circleSize;
                this.end %= SafeNodeImpl.this.circleSize;
                for (RecIn e : this.bufferIn) {
                    e.offset %= SafeNodeImpl.this.circleSize;
                }
            }
            return offset;
        }

        private void correctRanges() {
            if (this.begin >= SafeNodeImpl.this.circleSize) {
                this.begin %= SafeNodeImpl.this.circleSize;
                this.end %= SafeNodeImpl.this.circleSize;
            }
        }

        private void receiveDataFromRemote(int offset, byte[] data) {
            this.end = Math.max(this.end, offset + data.length);
            Value<byte[]> val = Value.of(data);
            if (offset == this.begin) {
                this.addBegin(data.length);
                SafeNodeImpl.this.up.inSide.send(val);
            } else {
                this.bufferIn.add(new RecIn(offset, val));
            }
            this.removeReadArrays();
        }

        @Override
        public void confirmReceive(short offset) {
            this.confirmReceiveInt(Short.toUnsignedInt(offset));
        }

        @Override
        public void confirmSend(short offset) {
            this.confirmSendInt(Short.toUnsignedInt(offset));
        }

        @Override
        public void confirmSendInt(int offset) {
            if (offset != this.end) {
                SafeNodeImpl.this.confirmToRemote(offset);
            }
        }

        @Override
        public void confirmReceiveInt(int offset) {
            SafeNodeImpl.this.upWorker.confirmRemoteReceive(offset);
        }

        private void addBegin(int val) {
            this.begin += val;
            this.correctRanges();
            SafeNodeImpl.this.needSendStatus = true;
            SafeNodeImpl.this.autoFlush.needWork();
        }

        private void removeReadArrays() {
            while (!this.bufferIn.isEmpty()) {
                RecIn d = this.bufferIn.first();
                if (d.offset == this.begin) {
                    this.bufferIn.remove(d);
                    SafeNodeImpl.this.up.inSide.send(d.data);
                    this.addBegin(d.data.data().length);
                    continue;
                }
                if (d.offset >= this.begin) break;
                this.bufferIn.remove(d);
                if (d.offset + d.len() <= this.begin) continue;
                int s = this.begin - d.offset;
                int l = d.len() - s;
                SafeNodeImpl.this.up.inSide.send(Value.of(Arrays.copyOfRange(d.data.data(), s, l)));
                this.addBegin(l);
            }
            SafeNodeImpl.this.needSendStatus = true;
            SafeNodeImpl.this.autoFlush.needWork();
        }

        private short convertShort(int value) {
            return (short)SafeNodeImpl.this.convert(value);
        }

        @Override
        public void sendInt(int offset, byte[] data) {
            offset = this.convertOffsetToLocal(offset);
            this.receiveDataFromRemote(offset, data);
        }

        @Override
        public void repeat(short repeat, short offset, byte[] data) {
            this.repeatInt(Short.toUnsignedInt(repeat), Short.toUnsignedInt(offset), data);
        }

        @Override
        public void repeatInt(int repeat, int offset, byte[] data) {
            offset = this.convertOffsetToLocal(offset);
            this.receiveDataFromRemote(offset, data);
        }
    }

    private static final class RecIn
    implements Comparable<RecIn> {
        private final Value<byte[]> data;
        private int offset;

        private RecIn(int offset, Value<byte[]> data) {
            this.offset = offset;
            this.data = data;
        }

        public int len() {
            return this.data.data().length;
        }

        @Override
        public int compareTo(@NotNull RecIn o) {
            return this.offset - o.offset;
        }

        public int end() {
            return this.offset + this.data.data().length;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            RecIn that = (RecIn)obj;
            return this.offset == that.offset && Arrays.equals(this.data.data(), that.data.data());
        }

        public int hashCode() {
            return Objects.hash(this.offset, this.data);
        }

        public String toString() {
            return "RecIn[offset=" + this.offset + ", data=" + Arrays.toString(this.data.data()) + "]";
        }
    }

    private static interface SafeStreamApi {
        @Command(value=3)
        public void close();

        @Command(value=6)
        public void confirmReceive(short var1);

        @Command(value=7)
        public void confirmSend(short var1);

        @Command(value=8)
        public void requestRepeat(short var1, short var2);

        @Command(value=8)
        public void send(short var1, byte[] var2);

        @Command(value=9)
        public void repeat(short var1, short var2, byte[] var3);

        @Command(value=11)
        public void requestRepeatAfter(short var1);

        @Command(value=12)
        public void repeatInt(int var1, int var2, byte[] var3);

        @Command(value=13)
        public void requestRepeatAfterInt(int var1);

        @Command(value=14)
        public void sendInt(int var1, byte[] var2);

        @Command(value=15)
        public void requestRepeatInt(int var1, int var2);

        @Command(value=17)
        public void confirmReceiveInt(int var1);

        @Command(value=18)
        public void confirmSendInt(int var1);

        @Command(value=25)
        public void status(short var1, short var2);

        @Command(value=26)
        public void statusInt(int var1, int var2);
    }
}

