package io.aether.crypto.hydrogen;

import io.aether.crypto.Sign;
import io.aether.crypto.CryptoProvider;
import io.aether.utils.HexUtils;

public class HydrogenSign implements Sign {
    private static final int SIGNATURE_LENGTH = 64;
    private final byte[] data;

    public HydrogenSign(byte[] data) {
        if (data == null) {
            throw new NullPointerException("Signature data cannot be null.");
        }
        if (data.length != SIGNATURE_LENGTH) {
            throw new IllegalArgumentException(
                    "Invalid signature length for HYDROGEN. Expected " + SIGNATURE_LENGTH + " bytes, but got " + data.length + " bytes."
            );
        }
        this.data = data;
    }

    @Override
    public byte[] getSignData() {
        return data;
    }

    @Override
    public String getProviderName() {
        return "HYDROGEN";
    }

    @Override
    public String toString() {
        return getProviderName() + ":" + HexUtils.toHexString(getSignData());
    }

    @Override
    public CryptoProvider getCryptoProvider() {
        return HydrogenCryptoProvider.INSTANCE;
    }
}