/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto.hydrogen;

import io.aether.crypto.AKey;
import io.aether.crypto.CryptoEngine;
import io.aether.crypto.CryptoProvider;
import io.aether.crypto.DecryptException;
import io.aether.crypto.hydrogen.HydrogenCryptoProvider;
import io.aether.crypto.hydrogen.HydrogenKey;
import io.aether.crypto.hydrogen.HydrogenSymmetricEngine;
import io.aether.nativeLib.HydrogenLib;
import java.util.Arrays;

public class HydrogenAsymmetricEngine
implements CryptoEngine {
    private final HydrogenLib.hydro_kx_session_keypair session_kp;
    private final HydrogenLib.hydro_kx_keypair keypair;
    private final AKey.AsymmetricPublic publicKey;
    private final AKey.AsymmetricPrivate privateKey;

    public HydrogenAsymmetricEngine(AKey.AsymmetricPublic publicKey) {
        this.publicKey = publicKey;
        this.privateKey = null;
        this.session_kp = new HydrogenLib.hydro_kx_session_keypair();
        this.keypair = new HydrogenLib.hydro_kx_keypair(publicKey.getData(), null);
    }

    public HydrogenAsymmetricEngine(AKey.AsymmetricPrivate privateKey, AKey.AsymmetricPublic publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.session_kp = new HydrogenLib.hydro_kx_session_keypair();
        this.keypair = new HydrogenLib.hydro_kx_keypair(publicKey.getData(), privateKey.getData());
    }

    public byte[] encrypt(byte[] data) {
        byte[] ephemeral_pk = new byte[48];
        HydrogenLib.hydro_kx_n_1(this.session_kp, ephemeral_pk, null, this.publicKey.getData());
        HydrogenKey.Symmetric symmetricKey = new HydrogenKey.Symmetric(this.session_kp.tx);
        HydrogenSymmetricEngine symmetricEngine = new HydrogenSymmetricEngine(symmetricKey);
        byte[] encryptedData = symmetricEngine.encrypt(data);
        return HydrogenAsymmetricEngine.addArray(ephemeral_pk, encryptedData);
    }

    public byte[] decrypt(byte[] data) {
        if (this.privateKey == null) {
            throw new UnsupportedOperationException("This engine is not configured for decryption.");
        }
        byte[] ephemeral_pk = Arrays.copyOfRange(data, 0, 48);
        byte[] in = Arrays.copyOfRange(data, 48, data.length);
        if (0 != HydrogenLib.hydro_kx_n_2(this.session_kp, ephemeral_pk, null, this.keypair)) {
            throw new DecryptException("Failed to derive session keys for decryption.");
        }
        HydrogenKey.Symmetric symmetricKey = new HydrogenKey.Symmetric(this.session_kp.rx);
        HydrogenSymmetricEngine symmetricEngine = new HydrogenSymmetricEngine(symmetricKey);
        return symmetricEngine.decrypt(in);
    }

    public CryptoProvider getCryptoProvider() {
        return HydrogenCryptoProvider.INSTANCE;
    }

    public String getProviderName() {
        return "HYDROGEN";
    }

    private static byte[] addArray(byte[] a1, byte[] a2) {
        byte[] res = new byte[a1.length + a2.length];
        System.arraycopy(a1, 0, res, 0, a1.length);
        System.arraycopy(a2, 0, res, a1.length, a2.length);
        return res;
    }
}

