/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto.hydrogen;

import io.aether.crypto.AKey;
import io.aether.crypto.CryptoEngine;
import io.aether.crypto.CryptoProvider;
import io.aether.crypto.KeyType;
import io.aether.crypto.PairAsymKeys;
import io.aether.crypto.PairSignKeys;
import io.aether.crypto.Sign;
import io.aether.crypto.Signer;
import io.aether.crypto.hydrogen.HydrogenAsymmetricEngine;
import io.aether.crypto.hydrogen.HydrogenKey;
import io.aether.crypto.hydrogen.HydrogenSign;
import io.aether.crypto.hydrogen.HydrogenSigner;
import io.aether.crypto.hydrogen.HydrogenSymmetricEngine;
import io.aether.nativeLib.HydrogenLib;
import io.aether.utils.HexUtils;
import io.aether.utils.RU;

public class HydrogenCryptoProvider
implements CryptoProvider {
    public static final HydrogenCryptoProvider INSTANCE = new HydrogenCryptoProvider();

    private HydrogenCryptoProvider() {
    }

    public AKey.SignPublic createSignPublicKey(byte[] data) {
        return new HydrogenKey.SignPublic(data);
    }

    public AKey.SignPrivate createSignPrivateKey(byte[] data) {
        return new HydrogenKey.SignPrivate(data);
    }

    public String getCryptoLibName() {
        return "HYDROGEN";
    }

    public AKey.Symmetric createSymmetricKey(byte[] bytes) {
        return new HydrogenKey.Symmetric(bytes);
    }

    public PairAsymKeys createAsymmetricKeys() {
        HydrogenLib.hydro_kx_keypair keys = new HydrogenLib.hydro_kx_keypair();
        HydrogenLib.hydro_kx_keygen(keys);
        return new PairAsymKeys((AKey.AsymmetricPublic)new HydrogenKey.AsymmetricPublic(keys.pk), (AKey.AsymmetricPrivate)new HydrogenKey.AsymmetricPrivate(keys.sk));
    }

    public AKey.Symmetric createSymmetricKey() {
        byte[] key = new byte[32];
        HydrogenLib.hydro_secretbox_keygen(key);
        return new HydrogenKey.Symmetric(key);
    }

    public PairSignKeys createSignKeys() {
        HydrogenLib.hydro_sign_keypair keys = new HydrogenLib.hydro_sign_keypair();
        HydrogenLib.hydro_sign_keygen(keys);
        return new PairSignKeys((AKey.SignPublic)new HydrogenKey.SignPublic(keys.pk), (AKey.SignPrivate)new HydrogenKey.SignPrivate(keys.sk));
    }

    public Signer createSigner(PairSignKeys keys) {
        return this.createSigner(keys.publicKey, keys.privateKey);
    }

    public Signer createSigner(AKey.SignPublic publicKey, AKey.SignPrivate privateKey) {
        if (!(publicKey instanceof HydrogenKey.SignPublic) || !(privateKey instanceof HydrogenKey.SignPrivate)) {
            throw new IllegalArgumentException("Keys must be instances of HydrogenKey.SignPublic and HydrogenKey.SignPrivate");
        }
        return new HydrogenSigner(publicKey, privateKey);
    }

    public Signer createSigner(AKey.SignPublic publicKey) {
        if (!(publicKey instanceof HydrogenKey.SignPublic)) {
            throw new IllegalArgumentException("Public key must be an instance of HydrogenKey.SignPublic");
        }
        return new HydrogenSigner(publicKey, null);
    }

    public CryptoEngine createSymmetricEngine(AKey.Symmetric key) {
        if (!(key instanceof HydrogenKey.Symmetric)) {
            throw new IllegalArgumentException("Key must be a HydrogenKey.Symmetric instance");
        }
        return new HydrogenSymmetricEngine(key);
    }

    public CryptoEngine createAsymmetricEngine(AKey.AsymmetricPublic key) {
        if (!(key instanceof HydrogenKey.AsymmetricPublic)) {
            throw new IllegalArgumentException("Key must be a HydrogenKey.AsymmetricPublic instance");
        }
        return new HydrogenAsymmetricEngine(key);
    }

    public CryptoEngine createAsymmetricEngine(AKey.AsymmetricPrivate privateKey, AKey.AsymmetricPublic publicKey) {
        if (!(privateKey instanceof HydrogenKey.AsymmetricPrivate) || !(publicKey instanceof HydrogenKey.AsymmetricPublic)) {
            throw new IllegalArgumentException("Keys must be instances of HydrogenKey.AsymmetricPrivate and HydrogenKey.AsymmetricPublic");
        }
        return new HydrogenAsymmetricEngine(privateKey, publicKey);
    }

    public CryptoEngine createAsymmetricEngine(PairAsymKeys keys) {
        return this.createAsymmetricEngine(keys.getPrivateKey(), keys.getPublicKey());
    }

    public <T extends AKey> T createKey(KeyType keyType, byte[] data) {
        HydrogenKey res = switch (keyType) {
            case KeyType.SYMMETRIC -> new HydrogenKey.Symmetric(data);
            case KeyType.ASYMMETRIC_PUBLIC -> new HydrogenKey.AsymmetricPublic(data);
            case KeyType.ASYMMETRIC_PRIVATE -> new HydrogenKey.AsymmetricPrivate(data);
            case KeyType.SIGN_PUBLIC -> new HydrogenKey.SignPublic(data);
            case KeyType.SIGN_PRIVATE -> new HydrogenKey.SignPrivate(data);
            default -> throw new UnsupportedOperationException();
        };
        return (T)((AKey)RU.cast((Object)res));
    }

    public <T extends AKey> T createKey(String data) {
        String[] parts = data.split(":");
        if (parts.length != 3 || !parts[0].equals(this.getCryptoLibName())) {
            throw new IllegalArgumentException("Invalid key string for this provider.");
        }
        KeyType keyType = KeyType.valueOf((String)parts[1]);
        byte[] bytes = HexUtils.hexToBytes((CharSequence)parts[2]);
        return (T)((AKey)RU.cast(this.createKey(keyType, bytes)));
    }

    public Sign createSign(String data) {
        String[] parts = data.split(":");
        if (parts.length != 2 || !parts[0].equals(this.getCryptoLibName())) {
            throw new IllegalArgumentException("Invalid sign string for this provider.");
        }
        return new HydrogenSign(HexUtils.hexToBytes((CharSequence)parts[1]));
    }

    public Sign createSign(byte[] data) {
        return new HydrogenSign(data);
    }
}

