/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto.hydrogen;

import io.aether.crypto.AKey;
import io.aether.crypto.CryptoEngine;
import io.aether.crypto.CryptoProvider;
import io.aether.crypto.CryptoProviderFactory;
import io.aether.crypto.KeyType;
import io.aether.crypto.SignChecker;
import io.aether.crypto.hydrogen.HydrogenCryptoProvider;
import io.aether.utils.HexUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public abstract class HydrogenKey
implements AKey {
    protected final byte[] data;
    protected final KeyType keyType;
    protected final String providerName = "HYDROGEN";
    public static final byte[] HYDROGEN_LIB_CTX = "aetherio".getBytes(StandardCharsets.UTF_8);

    protected HydrogenKey(byte[] data, KeyType keyType) {
        this.data = data;
        this.keyType = keyType;
    }

    public byte[] getData() {
        return this.data;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public String getProviderName() {
        return "HYDROGEN";
    }

    public CryptoProvider getCryptoProvider() {
        return HydrogenCryptoProvider.INSTANCE;
    }

    public int size() {
        return this.data.length;
    }

    public String keyToString() {
        return this.getProviderName() + ":" + String.valueOf(this.getKeyType()) + ":" + HexUtils.toHexString((byte[])this.getData());
    }

    public String toString() {
        return this.keyToString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AKey) {
            AKey k = (AKey)obj;
            return this.getKeyType() == k.getKeyType() && this.getProviderName().equals(k.getProviderName()) && Arrays.equals(this.getData(), k.getData());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getKeyType(), this.getProviderName(), Arrays.hashCode(this.getData()));
    }

    public static class SignPublic
    extends HydrogenKey
    implements AKey.SignPublic {
        public SignPublic(byte[] data) {
            super(data, KeyType.SIGN_PUBLIC);
        }

        public SignChecker toSignChecker() {
            return CryptoProviderFactory.getProvider((AKey)this).createSigner((AKey.SignPublic)this);
        }
    }

    public static class SignPrivate
    extends HydrogenKey
    implements AKey.SignPrivate {
        public SignPrivate(byte[] data) {
            super(data, KeyType.SIGN_PRIVATE);
        }
    }

    public static class AsymmetricPublic
    extends HydrogenKey
    implements AKey.AsymmetricPublic {
        public AsymmetricPublic(byte[] data) {
            super(data, KeyType.ASYMMETRIC_PUBLIC);
        }

        public CryptoEngine toCryptoEngine() {
            return CryptoProviderFactory.getProvider((AKey)this).createAsymmetricEngine((AKey.AsymmetricPublic)this);
        }
    }

    public static class AsymmetricPrivate
    extends HydrogenKey
    implements AKey.AsymmetricPrivate {
        public AsymmetricPrivate(byte[] data) {
            super(data, KeyType.ASYMMETRIC_PRIVATE);
        }
    }

    public static class Symmetric
    extends HydrogenKey
    implements AKey.Symmetric {
        public Symmetric(byte[] data) {
            super(data, KeyType.SYMMETRIC);
        }

        public CryptoEngine toCryptoEngine() {
            return CryptoProviderFactory.getProvider((AKey)this).createSymmetricEngine((AKey.Symmetric)this);
        }
    }
}

