/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto.hydrogen;

import io.aether.crypto.CryptoProvider;
import io.aether.crypto.Sign;
import io.aether.crypto.hydrogen.HydrogenCryptoProvider;
import io.aether.utils.HexUtils;

public class HydrogenSign
implements Sign {
    private static final int SIGNATURE_LENGTH = 64;
    private final byte[] data;

    public HydrogenSign(byte[] data) {
        if (data == null) {
            throw new NullPointerException("Signature data cannot be null.");
        }
        if (data.length != 64) {
            throw new IllegalArgumentException("Invalid signature length for HYDROGEN. Expected 64 bytes, but got " + data.length + " bytes.");
        }
        this.data = data;
    }

    public byte[] getSignData() {
        return this.data;
    }

    public String getProviderName() {
        return "HYDROGEN";
    }

    public String toString() {
        return this.getProviderName() + ":" + HexUtils.toHexString((byte[])this.getSignData());
    }

    public CryptoProvider getCryptoProvider() {
        return HydrogenCryptoProvider.INSTANCE;
    }
}

