/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto.hydrogen;

import io.aether.crypto.AKey;
import io.aether.crypto.CryptoProvider;
import io.aether.crypto.Sign;
import io.aether.crypto.Signer;
import io.aether.crypto.hydrogen.HydrogenCryptoProvider;
import io.aether.crypto.hydrogen.HydrogenKey;
import io.aether.crypto.hydrogen.HydrogenSign;
import io.aether.nativeLib.HydrogenLib;

public class HydrogenSigner
implements Signer {
    private final AKey.SignPublic publicKey;
    private final AKey.SignPrivate privateKey;

    public HydrogenSigner(AKey.SignPublic publicKey, AKey.SignPrivate privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public Sign sign(byte[] data) {
        if (this.privateKey == null) {
            throw new IllegalStateException("This Signer instance is not configured with a private key for signing.");
        }
        byte[] sign = new byte[64];
        HydrogenLib.hydro_sign_create(sign, data, HydrogenKey.HYDROGEN_LIB_CTX, this.privateKey.getData());
        return new HydrogenSign(sign);
    }

    public boolean checkSign(byte[] data, Sign sign) {
        if (!(sign instanceof HydrogenSign)) {
            throw new IllegalArgumentException("Sign must be a HydrogenSign instance");
        }
        if (this.publicKey == null) {
            throw new IllegalStateException("This Signer instance is not configured with a public key for checking.");
        }
        return HydrogenLib.hydro_sign_verify(sign.getSignData(), data, HydrogenKey.HYDROGEN_LIB_CTX, this.publicKey.getData()) == 0;
    }

    public AKey.SignPublic getPublicKey() {
        return this.publicKey;
    }

    public CryptoProvider getCryptoProvider() {
        return HydrogenCryptoProvider.INSTANCE;
    }
}

