/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto.hydrogen;

import io.aether.crypto.AKey;
import io.aether.crypto.CryptoEngine;
import io.aether.crypto.CryptoProvider;
import io.aether.crypto.DecryptException;
import io.aether.crypto.EncryptException;
import io.aether.crypto.hydrogen.HydrogenCryptoProvider;
import io.aether.crypto.hydrogen.HydrogenKey;
import io.aether.nativeLib.HydrogenLib;
import io.aether.utils.DataUtils;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;

public class HydrogenSymmetricEngine
implements CryptoEngine {
    private final AKey.Symmetric key;
    private final AtomicLong msgId = new AtomicLong(0L);

    public HydrogenSymmetricEngine(AKey.Symmetric key) {
        this.key = key;
    }

    public byte[] encrypt(byte[] data) {
        long currentMsgId = this.msgId.incrementAndGet();
        byte[] result = new byte[44 + data.length];
        DataUtils.writeLongLE((byte[])result, (int)0, (long)currentMsgId);
        byte[] encryptedOutputBuffer = new byte[36 + data.length];
        if (0 != HydrogenLib.hydro_secretbox_encrypt(encryptedOutputBuffer, data, currentMsgId, HydrogenKey.HYDROGEN_LIB_CTX, this.key.getData())) {
            throw new EncryptException();
        }
        System.arraycopy(encryptedOutputBuffer, 0, result, 8, encryptedOutputBuffer.length);
        return result;
    }

    public byte[] decrypt(byte[] data) {
        if (data.length < 44) {
            throw new DecryptException("Invalid data length. Missing msgId or header.");
        }
        long currentMsgId = DataUtils.readLongLE((byte[])data, (int)0);
        byte[] encryptedData = Arrays.copyOfRange(data, 8, data.length);
        byte[] result = new byte[encryptedData.length - 36];
        if (0 != HydrogenLib.hydro_secretbox_decrypt(result, encryptedData, currentMsgId, HydrogenKey.HYDROGEN_LIB_CTX, this.key.getData())) {
            throw new DecryptException();
        }
        return result;
    }

    public String getProviderName() {
        return "HYDROGEN";
    }

    public CryptoProvider getCryptoProvider() {
        return HydrogenCryptoProvider.INSTANCE;
    }
}

