/*
 * Decompiled with CFR 0.152.
 */
package io.aether.nativeLib;

import io.aether.utils.RU;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;

public final class HydrogenLib {
    public static final int hydro_secretbox_CONTEXTBYTES = 8;
    public static final int hydro_secretbox_HEADERBYTES = 36;
    public static final int hydro_secretbox_KEYBYTES = 32;
    public static final int hydro_secretbox_PROBEBYTES = 16;
    public static final int hydro_kx_SESSIONKEYBYTES = 32;
    public static final int hydro_kx_PUBLICKEYBYTES = 32;
    public static final int hydro_kx_SECRETKEYBYTES = 32;
    public static final int hydro_kx_PSKBYTES = 32;
    public static final int hydro_kx_SEEDBYTES = 32;
    public static final int hydro_kx_N_PACKET1BYTES = 48;
    public static final int hydro_kx_KK_PACKET1BYTES = 48;
    public static final int hydro_kx_KK_PACKET2BYTES = 48;
    public static final int hydro_hash_BYTES = 32;
    public static final int hydro_hash_BYTES_MAX = 65535;
    public static final int hydro_hash_BYTES_MIN = 16;
    public static final int hydro_hash_CONTEXTBYTES = 8;
    public static final int hydro_hash_KEYBYTES = 32;
    public static final int hydro_sign_BYTES = 64;
    public static final int hydro_sign_CONTEXTBYTES = 8;
    public static final int hydro_sign_PUBLICKEYBYTES = 32;
    public static final int hydro_sign_SECRETKEYBYTES = 64;
    public static final int hydro_sign_SEEDBYTES = 32;
    public static final int hydro_kdf_CONTEXTBYTES = 8;
    public static final int hydro_kdf_KEYBYTES = 32;
    public static final int hydro_kdf_BYTES_MAX = 65535;
    public static final int hydro_kdf_BYTES_MIN = 16;
    public static final int hydro_kx_XX_PACKET1BYTES = 48;
    public static final int hydro_kx_XX_PACKET2BYTES = 80;
    public static final int hydro_kx_XX_PACKET3BYTES = 48;
    public static final int hydro_kx_NK_PACKET1BYTES = 48;
    public static final int hydro_kx_NK_PACKET2BYTES = 48;
    public static final int hydro_pwhash_CONTEXTBYTES = 8;
    public static final int hydro_pwhash_MASTERKEYBYTES = 32;
    public static final int hydro_pwhash_STOREDBYTES = 128;
    private static final MethodHandle HYDRO_SECRETBOX_PROBE_CREATE_HANDLE;
    private static final MethodHandle HYDRO_SECRETBOX_PROBE_VERIFY_HANDLE;
    private static final MethodHandle HYDRO_HASH_KEYGEN_HANDLE;
    private static final MethodHandle HYDRO_HASH_INIT_HANDLE;
    private static final MethodHandle HYDRO_HASH_UPDATE_HANDLE;
    private static final MethodHandle HYDRO_HASH_FINAL_HANDLE;
    private static final MethodHandle HYDRO_HASH_HASH_HANDLE;
    private static final MethodHandle HYDRO_KX_KEYGEN_HANDLE;
    private static final MethodHandle HYDRO_KX_KEYGEN_DETERMINISTIC_HANDLE;
    private static final MethodHandle HYDRO_KX_N_1_HANDLE;
    private static final MethodHandle HYDRO_KX_KK_1_HANDLE;
    private static final MethodHandle HYDRO_KX_N_2_HANDLE;
    private static final MethodHandle HYDRO_KX_KK_2_HANDLE;
    private static final MethodHandle HYDRO_KX_KK_3_HANDLE;
    private static final MethodHandle HYDRO_KX_XX_1_HANDLE;
    private static final MethodHandle HYDRO_KX_XX_2_HANDLE;
    private static final MethodHandle HYDRO_KX_XX_3_HANDLE;
    private static final MethodHandle HYDRO_KX_XX_4_HANDLE;
    private static final MethodHandle HYDRO_KX_NK_1_HANDLE;
    private static final MethodHandle HYDRO_KX_NK_2_HANDLE;
    private static final MethodHandle HYDRO_KX_NK_3_HANDLE;
    private static final MethodHandle HYDRO_PWHASH_KEYGEN_HANDLE;
    private static final MethodHandle HYDRO_PWHASH_DETERMINISTIC_HANDLE;
    private static final MethodHandle HYDRO_PWHASH_CREATE_HANDLE;
    private static final MethodHandle HYDRO_PWHASH_VERIFY_HANDLE;
    private static final MethodHandle HYDRO_PWHASH_DERIVE_STATIC_KEY_HANDLE;
    private static final MethodHandle HYDRO_PWHASH_REENCRYPT_HANDLE;
    private static final MethodHandle HYDRO_PWHASH_UPGRADE_HANDLE;
    private static final MethodHandle HYDRO_SECRETBOX_KEYGEN_HANDLE;
    private static final MethodHandle HYDRO_SECRETBOX_ENCRYPT_HANDLE;
    private static final MethodHandle HYDRO_SECRETBOX_DECRYPT_HANDLE;
    private static final MethodHandle HYDRO_KDF_KEYGEN_HANDLE;
    private static final MethodHandle HYDRO_KDF_DERIVE_FROM_KEY_HANDLE;
    private static final MethodHandle HYDRO_SIGN_KEYGEN_HANDLE;
    private static final MethodHandle HYDRO_SIGN_KEYGEN_DETERMINISTIC_HANDLE;
    private static final MethodHandle HYDRO_SIGN_INIT_HANDLE;
    private static final MethodHandle HYDRO_SIGN_UPDATE_HANDLE;
    private static final MethodHandle HYDRO_SIGN_FINAL_CREATE_HANDLE;
    private static final MethodHandle HYDRO_SIGN_FINAL_VERIFY_HANDLE;
    private static final MethodHandle HYDRO_SIGN_CREATE_HANDLE;
    private static final MethodHandle HYDRO_SIGN_VERIFY_HANDLE;
    private static final Linker LINKER;
    private static final SymbolLookup SYMBOL_LOOKUP;

    public static int hydro_secretbox_probe_create(byte[] probe, byte[] c, byte[] ctx, byte[] key) {
        if (probe == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'probe' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (probe != null && probe.length != 16) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'probe' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_secretbox_PROBEBYTES.");
        }
        if (c == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'c' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx != null && ctx.length != 8) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_secretbox_CONTEXTBYTES.");
        }
        if (key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (key != null && key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_secretbox_KEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment probeSegment = probe == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, probe);
            MemorySegment cSegment = c == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, c);
            long cLength = c == null ? 0L : (long)c.length;
            MemorySegment ctxSegment = ctx == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, ctx);
            MemorySegment keySegment = key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, key);
            int result = HYDRO_SECRETBOX_PROBE_CREATE_HANDLE.invokeExact(probeSegment, cSegment, cLength, ctxSegment, keySegment);
            if (probe != null) {
                MemorySegment.copy(probeSegment, 0L, MemorySegment.ofArray(probe), 0L, probe.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_secretbox_probe_create", e);
            }
        }
    }

    public static int hydro_secretbox_probe_verify(byte[] probe, byte[] c, byte[] ctx, byte[] key) {
        if (probe == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'probe' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (probe != null && probe.length != 16) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'probe' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_secretbox_PROBEBYTES.");
        }
        if (c == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'c' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx != null && ctx.length != 8) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_secretbox_CONTEXTBYTES.");
        }
        if (key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (key != null && key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_secretbox_KEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            int result;
            MemorySegment probeSegment = probe == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, probe);
            MemorySegment cSegment = c == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, c);
            long cLength = c == null ? 0L : (long)c.length;
            MemorySegment ctxSegment = ctx == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, ctx);
            MemorySegment keySegment = key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, key);
            int n = result = HYDRO_SECRETBOX_PROBE_VERIFY_HANDLE.invokeExact(probeSegment, cSegment, cLength, ctxSegment, keySegment);
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_secretbox_probe_verify", e);
            }
        }
    }

    public static void hydro_hash_keygen(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (key != null && key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_hash_KEYBYTES.");
        }
        try (Arena arena = Arena.ofConfined();){
            MemorySegment keySegment = key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, key);
            HYDRO_HASH_KEYGEN_HANDLE.invokeExact(keySegment);
            if (key != null) {
                MemorySegment.copy(keySegment, 0L, MemorySegment.ofArray(key), 0L, key.length);
            }
            return;
        }
        catch (Throwable e) {
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_hash_keygen", e);
        }
    }

    public static int hydro_hash_init(hydro_hash_state state, byte[] ctx, byte[] key) {
        if (state == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'state' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx != null && ctx.length != 8) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_hash_CONTEXTBYTES.");
        }
        if (key != null && key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_hash_KEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment stateSegment;
            MemorySegment memorySegment = stateSegment = state == null ? MemorySegment.NULL : arena.allocate(hydro_hash_state.getStaticSize());
            if (state != null) {
                state.serialize(stateSegment, 0L, arena);
            }
            MemorySegment ctxSegment = ctx == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, ctx);
            MemorySegment keySegment = key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, key);
            int result = HYDRO_HASH_INIT_HANDLE.invokeExact(stateSegment, ctxSegment, keySegment);
            if (state != null) {
                state.deserialize(stateSegment, 0L);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_hash_init", e);
            }
        }
    }

    public static int hydro_hash_update(hydro_hash_state state, byte[] in_) {
        if (state == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'state' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (in_ == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'in_' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment stateSegment;
            MemorySegment memorySegment = stateSegment = state == null ? MemorySegment.NULL : arena.allocate(hydro_hash_state.getStaticSize());
            if (state != null) {
                state.serialize(stateSegment, 0L, arena);
            }
            MemorySegment inSegment = in_ == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, in_);
            long in_Length = in_ == null ? 0L : (long)in_.length;
            int result = HYDRO_HASH_UPDATE_HANDLE.invokeExact(stateSegment, inSegment, in_Length);
            if (state != null) {
                state.deserialize(stateSegment, 0L);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_hash_update", e);
            }
        }
    }

    public static int hydro_hash_final(hydro_hash_state state, byte[] out) {
        if (state == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'state' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (out == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'out' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment stateSegment;
            MemorySegment memorySegment = stateSegment = state == null ? MemorySegment.NULL : arena.allocate(hydro_hash_state.getStaticSize());
            if (state != null) {
                state.serialize(stateSegment, 0L, arena);
            }
            MemorySegment outSegment = out == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, out);
            long outLength = out == null ? 0L : (long)out.length;
            int result = HYDRO_HASH_FINAL_HANDLE.invokeExact(stateSegment, outSegment, outLength);
            if (state != null) {
                state.deserialize(stateSegment, 0L);
            }
            if (out != null) {
                MemorySegment.copy(outSegment, 0L, MemorySegment.ofArray(out), 0L, out.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_hash_final", e);
            }
        }
    }

    public static int hydro_hash_hash(byte[] out, byte[] in_, byte[] ctx, byte[] key) {
        if (out == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'out' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (in_ == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'in_' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx != null && ctx.length != 8) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_hash_CONTEXTBYTES.");
        }
        if (key != null && key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_hash_KEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment outSegment = out == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, out);
            long outLength = out == null ? 0L : (long)out.length;
            MemorySegment inSegment = in_ == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, in_);
            long in_Length = in_ == null ? 0L : (long)in_.length;
            MemorySegment ctxSegment = ctx == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, ctx);
            MemorySegment keySegment = key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, key);
            int result = HYDRO_HASH_HASH_HANDLE.invokeExact(outSegment, outLength, inSegment, in_Length, ctxSegment, keySegment);
            if (out != null) {
                MemorySegment.copy(outSegment, 0L, MemorySegment.ofArray(out), 0L, out.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_hash_hash", e);
            }
        }
    }

    public static void hydro_kx_keygen(hydro_kx_keypair keyPair) {
        if (keyPair == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'keyPair' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        try (Arena arena = Arena.ofConfined();){
            MemorySegment keyPairSegment;
            MemorySegment memorySegment = keyPairSegment = keyPair == null ? MemorySegment.NULL : arena.allocate(hydro_kx_keypair.getStaticSize());
            if (keyPair != null) {
                keyPair.serialize(keyPairSegment, 0L, arena);
            }
            HYDRO_KX_KEYGEN_HANDLE.invokeExact(keyPairSegment);
            if (keyPair != null) {
                keyPair.deserialize(keyPairSegment, 0L);
            }
            return;
        }
        catch (Throwable e) {
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_kx_keygen", e);
        }
    }

    public static void hydro_kx_keygen_deterministic(hydro_kx_keypair keyPair, byte[] seed) {
        if (keyPair == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'keyPair' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (seed == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'seed' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (seed != null && seed.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'seed' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_SEEDBYTES.");
        }
        try (Arena arena = Arena.ofConfined();){
            MemorySegment keyPairSegment;
            MemorySegment memorySegment = keyPairSegment = keyPair == null ? MemorySegment.NULL : arena.allocate(hydro_kx_keypair.getStaticSize());
            if (keyPair != null) {
                keyPair.serialize(keyPairSegment, 0L, arena);
            }
            MemorySegment seedSegment = seed == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, seed);
            HYDRO_KX_KEYGEN_DETERMINISTIC_HANDLE.invokeExact(keyPairSegment, seedSegment);
            if (keyPair != null) {
                keyPair.deserialize(keyPairSegment, 0L);
            }
            return;
        }
        catch (Throwable e) {
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_kx_keygen_deterministic", e);
        }
    }

    public static int hydro_kx_n_1(hydro_kx_session_keypair keypair, byte[] packet1, byte[] psk, byte[] peer_static_pk) {
        if (keypair == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'keypair' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet1 == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet1' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet1 != null && packet1.length != 48) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet1' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_N_PACKET1BYTES.");
        }
        if (psk != null && psk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'psk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_PSKBYTES.");
        }
        if (peer_static_pk == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'peer_static_pk' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (peer_static_pk != null && peer_static_pk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'peer_static_pk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_PUBLICKEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment keypairSegment;
            MemorySegment memorySegment = keypairSegment = keypair == null ? MemorySegment.NULL : arena.allocate(hydro_kx_session_keypair.getStaticSize());
            if (keypair != null) {
                keypair.serialize(keypairSegment, 0L, arena);
            }
            MemorySegment packet1Segment = packet1 == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, packet1);
            MemorySegment pskSegment = psk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, psk);
            MemorySegment peerstaticpkSegment = peer_static_pk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, peer_static_pk);
            int result = HYDRO_KX_N_1_HANDLE.invokeExact(keypairSegment, packet1Segment, pskSegment, peerstaticpkSegment);
            if (keypair != null) {
                keypair.deserialize(keypairSegment, 0L);
            }
            if (packet1 != null) {
                MemorySegment.copy(packet1Segment, 0L, MemorySegment.ofArray(packet1), 0L, packet1.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_kx_n_1", e);
            }
        }
    }

    public static int hydro_kx_kk_1(hydro_kx_state state, byte[] packet1, byte[] peer_static_pk, hydro_kx_keypair static_kp) {
        if (state == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'state' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet1 == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet1' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet1 != null && packet1.length != 48) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet1' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_KK_PACKET1BYTES.");
        }
        if (peer_static_pk != null && peer_static_pk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'peer_static_pk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_PUBLICKEYBYTES.");
        }
        if (static_kp == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'static_kp' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment statickpSegment;
            MemorySegment stateSegment;
            MemorySegment memorySegment = stateSegment = state == null ? MemorySegment.NULL : arena.allocate(hydro_kx_state.getStaticSize());
            if (state != null) {
                state.serialize(stateSegment, 0L, arena);
            }
            MemorySegment packet1Segment = packet1 == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, packet1);
            MemorySegment peerstaticpkSegment = peer_static_pk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, peer_static_pk);
            MemorySegment memorySegment2 = statickpSegment = static_kp == null ? MemorySegment.NULL : arena.allocate(hydro_kx_keypair.getStaticSize());
            if (static_kp != null) {
                static_kp.serialize(statickpSegment, 0L, arena);
            }
            int result = HYDRO_KX_KK_1_HANDLE.invokeExact(stateSegment, packet1Segment, peerstaticpkSegment, statickpSegment);
            if (state != null) {
                state.deserialize(stateSegment, 0L);
            }
            if (packet1 != null) {
                MemorySegment.copy(packet1Segment, 0L, MemorySegment.ofArray(packet1), 0L, packet1.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_kx_kk_1", e);
            }
        }
    }

    public static int hydro_kx_n_2(hydro_kx_session_keypair kp, byte[] packet1, byte[] psk, hydro_kx_keypair static_kp) {
        if (kp == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'kp' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet1 == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet1' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet1 != null && packet1.length != 48) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet1' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_N_PACKET1BYTES.");
        }
        if (psk != null && psk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'psk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_PSKBYTES.");
        }
        if (static_kp == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'static_kp' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment statickpSegment;
            MemorySegment kpSegment;
            MemorySegment memorySegment = kpSegment = kp == null ? MemorySegment.NULL : arena.allocate(hydro_kx_session_keypair.getStaticSize());
            if (kp != null) {
                kp.serialize(kpSegment, 0L, arena);
            }
            MemorySegment packet1Segment = packet1 == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, packet1);
            MemorySegment pskSegment = psk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, psk);
            MemorySegment memorySegment2 = statickpSegment = static_kp == null ? MemorySegment.NULL : arena.allocate(hydro_kx_keypair.getStaticSize());
            if (static_kp != null) {
                static_kp.serialize(statickpSegment, 0L, arena);
            }
            int result = HYDRO_KX_N_2_HANDLE.invokeExact(kpSegment, packet1Segment, pskSegment, statickpSegment);
            if (kp != null) {
                kp.deserialize(kpSegment, 0L);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_kx_n_2", e);
            }
        }
    }

    public static int hydro_kx_kk_2(hydro_kx_session_keypair kp, byte[] packet2, byte[] packet1, byte[] peer_static_pk, hydro_kx_keypair static_kp) {
        if (kp == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'kp' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet2 == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet2' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet2 != null && packet2.length != 48) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet2' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_KK_PACKET2BYTES.");
        }
        if (packet1 == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet1' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet1 != null && packet1.length != 48) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet1' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_KK_PACKET1BYTES.");
        }
        if (peer_static_pk == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'peer_static_pk' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (peer_static_pk != null && peer_static_pk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'peer_static_pk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_PUBLICKEYBYTES.");
        }
        if (static_kp == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'static_kp' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment statickpSegment;
            MemorySegment kpSegment;
            MemorySegment memorySegment = kpSegment = kp == null ? MemorySegment.NULL : arena.allocate(hydro_kx_session_keypair.getStaticSize());
            if (kp != null) {
                kp.serialize(kpSegment, 0L, arena);
            }
            MemorySegment packet2Segment = packet2 == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, packet2);
            MemorySegment packet1Segment = packet1 == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, packet1);
            MemorySegment peerstaticpkSegment = peer_static_pk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, peer_static_pk);
            MemorySegment memorySegment2 = statickpSegment = static_kp == null ? MemorySegment.NULL : arena.allocate(hydro_kx_keypair.getStaticSize());
            if (static_kp != null) {
                static_kp.serialize(statickpSegment, 0L, arena);
            }
            int result = HYDRO_KX_KK_2_HANDLE.invokeExact(kpSegment, packet2Segment, packet1Segment, peerstaticpkSegment, statickpSegment);
            if (kp != null) {
                kp.deserialize(kpSegment, 0L);
            }
            if (packet2 != null) {
                MemorySegment.copy(packet2Segment, 0L, MemorySegment.ofArray(packet2), 0L, packet2.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_kx_kk_2", e);
            }
        }
    }

    public static int hydro_kx_kk_3(hydro_kx_state state, hydro_kx_session_keypair kp, byte[] packet2, hydro_kx_keypair static_kp) {
        if (state == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'state' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (kp == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'kp' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet2 == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet2' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet2 != null && packet2.length != 48) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet2' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_KK_PACKET2BYTES.");
        }
        if (static_kp == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'static_kp' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment statickpSegment;
            MemorySegment kpSegment;
            MemorySegment stateSegment;
            MemorySegment memorySegment = stateSegment = state == null ? MemorySegment.NULL : arena.allocate(hydro_kx_state.getStaticSize());
            if (state != null) {
                state.serialize(stateSegment, 0L, arena);
            }
            MemorySegment memorySegment2 = kpSegment = kp == null ? MemorySegment.NULL : arena.allocate(hydro_kx_session_keypair.getStaticSize());
            if (kp != null) {
                kp.serialize(kpSegment, 0L, arena);
            }
            MemorySegment packet2Segment = packet2 == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, packet2);
            MemorySegment memorySegment3 = statickpSegment = static_kp == null ? MemorySegment.NULL : arena.allocate(hydro_kx_keypair.getStaticSize());
            if (static_kp != null) {
                static_kp.serialize(statickpSegment, 0L, arena);
            }
            int result = HYDRO_KX_KK_3_HANDLE.invokeExact(stateSegment, kpSegment, packet2Segment, statickpSegment);
            if (state != null) {
                state.deserialize(stateSegment, 0L);
            }
            if (kp != null) {
                kp.deserialize(kpSegment, 0L);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_kx_kk_3", e);
            }
        }
    }

    public static int hydro_kx_xx_1(hydro_kx_state state, byte[] packet1, byte[] psk) {
        if (state == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'state' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet1 == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet1' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet1 != null && packet1.length != 48) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet1' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_XX_PACKET1BYTES.");
        }
        if (psk != null && psk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'psk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_PSKBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment stateSegment;
            MemorySegment memorySegment = stateSegment = state == null ? MemorySegment.NULL : arena.allocate(hydro_kx_state.getStaticSize());
            if (state != null) {
                state.serialize(stateSegment, 0L, arena);
            }
            MemorySegment packet1Segment = packet1 == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, packet1);
            MemorySegment pskSegment = psk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, psk);
            int result = HYDRO_KX_XX_1_HANDLE.invokeExact(stateSegment, packet1Segment, pskSegment);
            if (state != null) {
                state.deserialize(stateSegment, 0L);
            }
            if (packet1 != null) {
                MemorySegment.copy(packet1Segment, 0L, MemorySegment.ofArray(packet1), 0L, packet1.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_kx_xx_1", e);
            }
        }
    }

    public static int hydro_kx_xx_2(hydro_kx_state state, byte[] packet2, byte[] packet1, byte[] psk, hydro_kx_keypair static_kp) {
        if (state == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'state' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet2 == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet2' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet2 != null && packet2.length != 80) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet2' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_XX_PACKET2BYTES.");
        }
        if (packet1 == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet1' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet1 != null && packet1.length != 48) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet1' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_XX_PACKET1BYTES.");
        }
        if (psk != null && psk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'psk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_PSKBYTES.");
        }
        if (static_kp == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'static_kp' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment statickpSegment;
            MemorySegment stateSegment;
            MemorySegment memorySegment = stateSegment = state == null ? MemorySegment.NULL : arena.allocate(hydro_kx_state.getStaticSize());
            if (state != null) {
                state.serialize(stateSegment, 0L, arena);
            }
            MemorySegment packet2Segment = packet2 == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, packet2);
            MemorySegment packet1Segment = packet1 == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, packet1);
            MemorySegment pskSegment = psk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, psk);
            MemorySegment memorySegment2 = statickpSegment = static_kp == null ? MemorySegment.NULL : arena.allocate(hydro_kx_keypair.getStaticSize());
            if (static_kp != null) {
                static_kp.serialize(statickpSegment, 0L, arena);
            }
            int result = HYDRO_KX_XX_2_HANDLE.invokeExact(stateSegment, packet2Segment, packet1Segment, pskSegment, statickpSegment);
            if (state != null) {
                state.deserialize(stateSegment, 0L);
            }
            if (packet2 != null) {
                MemorySegment.copy(packet2Segment, 0L, MemorySegment.ofArray(packet2), 0L, packet2.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_kx_xx_2", e);
            }
        }
    }

    public static int hydro_kx_xx_3(hydro_kx_state state, hydro_kx_session_keypair kp, byte[] packet3, byte[] peer_static_pk, byte[] packet2, byte[] psk, hydro_kx_keypair static_kp) {
        if (state == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'state' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (kp == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'kp' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet3 == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet3' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet3 != null && packet3.length != 48) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet3' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_XX_PACKET3BYTES.");
        }
        if (peer_static_pk == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'peer_static_pk' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (peer_static_pk != null && peer_static_pk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'peer_static_pk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_PUBLICKEYBYTES.");
        }
        if (packet2 == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet2' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet2 != null && packet2.length != 80) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet2' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_XX_PACKET2BYTES.");
        }
        if (psk != null && psk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'psk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_PSKBYTES.");
        }
        if (static_kp == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'static_kp' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment statickpSegment;
            MemorySegment kpSegment;
            MemorySegment stateSegment;
            MemorySegment memorySegment = stateSegment = state == null ? MemorySegment.NULL : arena.allocate(hydro_kx_state.getStaticSize());
            if (state != null) {
                state.serialize(stateSegment, 0L, arena);
            }
            MemorySegment memorySegment2 = kpSegment = kp == null ? MemorySegment.NULL : arena.allocate(hydro_kx_session_keypair.getStaticSize());
            if (kp != null) {
                kp.serialize(kpSegment, 0L, arena);
            }
            MemorySegment packet3Segment = packet3 == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, packet3);
            MemorySegment peerstaticpkSegment = peer_static_pk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, peer_static_pk);
            MemorySegment packet2Segment = packet2 == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, packet2);
            MemorySegment pskSegment = psk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, psk);
            MemorySegment memorySegment3 = statickpSegment = static_kp == null ? MemorySegment.NULL : arena.allocate(hydro_kx_keypair.getStaticSize());
            if (static_kp != null) {
                static_kp.serialize(statickpSegment, 0L, arena);
            }
            int result = HYDRO_KX_XX_3_HANDLE.invokeExact(stateSegment, kpSegment, packet3Segment, peerstaticpkSegment, packet2Segment, pskSegment, statickpSegment);
            if (state != null) {
                state.deserialize(stateSegment, 0L);
            }
            if (kp != null) {
                kp.deserialize(kpSegment, 0L);
            }
            if (packet3 != null) {
                MemorySegment.copy(packet3Segment, 0L, MemorySegment.ofArray(packet3), 0L, packet3.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_kx_xx_3", e);
            }
        }
    }

    public static int hydro_kx_xx_4(hydro_kx_state state, hydro_kx_session_keypair kp, byte[] peer_static_pk, byte[] packet3, byte[] psk) {
        if (state == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'state' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (kp == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'kp' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (peer_static_pk == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'peer_static_pk' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (peer_static_pk != null && peer_static_pk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'peer_static_pk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_PUBLICKEYBYTES.");
        }
        if (packet3 == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet3' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet3 != null && packet3.length != 48) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet3' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_XX_PACKET3BYTES.");
        }
        if (psk != null && psk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'psk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_PSKBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment kpSegment;
            MemorySegment stateSegment;
            MemorySegment memorySegment = stateSegment = state == null ? MemorySegment.NULL : arena.allocate(hydro_kx_state.getStaticSize());
            if (state != null) {
                state.serialize(stateSegment, 0L, arena);
            }
            MemorySegment memorySegment2 = kpSegment = kp == null ? MemorySegment.NULL : arena.allocate(hydro_kx_session_keypair.getStaticSize());
            if (kp != null) {
                kp.serialize(kpSegment, 0L, arena);
            }
            MemorySegment peerstaticpkSegment = peer_static_pk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, peer_static_pk);
            MemorySegment packet3Segment = packet3 == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, packet3);
            MemorySegment pskSegment = psk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, psk);
            int result = HYDRO_KX_XX_4_HANDLE.invokeExact(stateSegment, kpSegment, peerstaticpkSegment, packet3Segment, pskSegment);
            if (state != null) {
                state.deserialize(stateSegment, 0L);
            }
            if (kp != null) {
                kp.deserialize(kpSegment, 0L);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_kx_xx_4", e);
            }
        }
    }

    public static int hydro_kx_nk_1(hydro_kx_state state, byte[] packet1, byte[] psk, byte[] peer_static_pk) {
        if (state == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'state' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet1 == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet1' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet1 != null && packet1.length != 48) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet1' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_NK_PACKET1BYTES.");
        }
        if (psk != null && psk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'psk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_PSKBYTES.");
        }
        if (peer_static_pk == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'peer_static_pk' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (peer_static_pk != null && peer_static_pk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'peer_static_pk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_PUBLICKEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment stateSegment;
            MemorySegment memorySegment = stateSegment = state == null ? MemorySegment.NULL : arena.allocate(hydro_kx_state.getStaticSize());
            if (state != null) {
                state.serialize(stateSegment, 0L, arena);
            }
            MemorySegment packet1Segment = packet1 == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, packet1);
            MemorySegment pskSegment = psk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, psk);
            MemorySegment peerstaticpkSegment = peer_static_pk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, peer_static_pk);
            int result = HYDRO_KX_NK_1_HANDLE.invokeExact(stateSegment, packet1Segment, pskSegment, peerstaticpkSegment);
            if (state != null) {
                state.deserialize(stateSegment, 0L);
            }
            if (packet1 != null) {
                MemorySegment.copy(packet1Segment, 0L, MemorySegment.ofArray(packet1), 0L, packet1.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_kx_nk_1", e);
            }
        }
    }

    public static int hydro_kx_nk_2(hydro_kx_session_keypair kp, byte[] packet2, byte[] packet1, byte[] psk, hydro_kx_keypair static_kp) {
        if (kp == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'kp' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet2 == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet2' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet2 != null && packet2.length != 48) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet2' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_NK_PACKET2BYTES.");
        }
        if (packet1 == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet1' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet1 != null && packet1.length != 48) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet1' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_NK_PACKET1BYTES.");
        }
        if (psk != null && psk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'psk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_PSKBYTES.");
        }
        if (static_kp == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'static_kp' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment statickpSegment;
            MemorySegment kpSegment;
            MemorySegment memorySegment = kpSegment = kp == null ? MemorySegment.NULL : arena.allocate(hydro_kx_session_keypair.getStaticSize());
            if (kp != null) {
                kp.serialize(kpSegment, 0L, arena);
            }
            MemorySegment packet2Segment = packet2 == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, packet2);
            MemorySegment packet1Segment = packet1 == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, packet1);
            MemorySegment pskSegment = psk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, psk);
            MemorySegment memorySegment2 = statickpSegment = static_kp == null ? MemorySegment.NULL : arena.allocate(hydro_kx_keypair.getStaticSize());
            if (static_kp != null) {
                static_kp.serialize(statickpSegment, 0L, arena);
            }
            int result = HYDRO_KX_NK_2_HANDLE.invokeExact(kpSegment, packet2Segment, packet1Segment, pskSegment, statickpSegment);
            if (kp != null) {
                kp.deserialize(kpSegment, 0L);
            }
            if (packet2 != null) {
                MemorySegment.copy(packet2Segment, 0L, MemorySegment.ofArray(packet2), 0L, packet2.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_kx_nk_2", e);
            }
        }
    }

    public static int hydro_kx_nk_3(hydro_kx_state state, hydro_kx_session_keypair kp, byte[] packet2) {
        if (state == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'state' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (kp == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'kp' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet2 == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet2' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (packet2 != null && packet2.length != 48) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'packet2' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kx_NK_PACKET2BYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment kpSegment;
            MemorySegment stateSegment;
            MemorySegment memorySegment = stateSegment = state == null ? MemorySegment.NULL : arena.allocate(hydro_kx_state.getStaticSize());
            if (state != null) {
                state.serialize(stateSegment, 0L, arena);
            }
            MemorySegment memorySegment2 = kpSegment = kp == null ? MemorySegment.NULL : arena.allocate(hydro_kx_session_keypair.getStaticSize());
            if (kp != null) {
                kp.serialize(kpSegment, 0L, arena);
            }
            MemorySegment packet2Segment = packet2 == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, packet2);
            int result = HYDRO_KX_NK_3_HANDLE.invokeExact(stateSegment, kpSegment, packet2Segment);
            if (state != null) {
                state.deserialize(stateSegment, 0L);
            }
            if (kp != null) {
                kp.deserialize(kpSegment, 0L);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_kx_nk_3", e);
            }
        }
    }

    public static void hydro_pwhash_keygen(byte[] master_key) {
        if (master_key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'master_key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (master_key != null && master_key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'master_key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_pwhash_MASTERKEYBYTES.");
        }
        try (Arena arena = Arena.ofConfined();){
            MemorySegment masterkeySegment = master_key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, master_key);
            HYDRO_PWHASH_KEYGEN_HANDLE.invokeExact(masterkeySegment);
            if (master_key != null) {
                MemorySegment.copy(masterkeySegment, 0L, MemorySegment.ofArray(master_key), 0L, master_key.length);
            }
            return;
        }
        catch (Throwable e) {
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_pwhash_keygen", e);
        }
    }

    public static int hydro_pwhash_deterministic(byte[] h, byte[] passwd, byte[] ctx, byte[] master_key, long opslimit, int memlimit, byte threads) {
        if (h == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'h' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (passwd == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'passwd' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx != null && ctx.length != 8) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_pwhash_CONTEXTBYTES.");
        }
        if (master_key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'master_key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (master_key != null && master_key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'master_key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_pwhash_MASTERKEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment hSegment = h == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, h);
            long hLength = h == null ? 0L : (long)h.length;
            MemorySegment passwdSegment = passwd == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, passwd);
            long passwdLength = passwd == null ? 0L : (long)passwd.length;
            MemorySegment ctxSegment = ctx == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, ctx);
            MemorySegment masterkeySegment = master_key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, master_key);
            int result = HYDRO_PWHASH_DETERMINISTIC_HANDLE.invokeExact(hSegment, hLength, passwdSegment, passwdLength, ctxSegment, masterkeySegment, opslimit, memlimit, threads);
            if (h != null) {
                MemorySegment.copy(hSegment, 0L, MemorySegment.ofArray(h), 0L, h.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_pwhash_deterministic", e);
            }
        }
    }

    public static int hydro_pwhash_create(byte[] stored, byte[] passwd, byte[] master_key, long opslimit, int memlimit, byte threads) {
        if (stored == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'stored' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (stored != null && stored.length != 128) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'stored' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_pwhash_STOREDBYTES.");
        }
        if (passwd == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'passwd' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (master_key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'master_key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (master_key != null && master_key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'master_key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_pwhash_MASTERKEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment storedSegment = stored == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, stored);
            MemorySegment passwdSegment = passwd == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, passwd);
            long passwdLength = passwd == null ? 0L : (long)passwd.length;
            MemorySegment masterkeySegment = master_key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, master_key);
            int result = HYDRO_PWHASH_CREATE_HANDLE.invokeExact(storedSegment, passwdSegment, passwdLength, masterkeySegment, opslimit, memlimit, threads);
            if (stored != null) {
                MemorySegment.copy(storedSegment, 0L, MemorySegment.ofArray(stored), 0L, stored.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_pwhash_create", e);
            }
        }
    }

    public static int hydro_pwhash_verify(byte[] stored, byte[] passwd, byte[] master_key, long opslimit_max, int memlimit_max, byte threads_max) {
        if (stored == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'stored' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (stored != null && stored.length != 128) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'stored' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_pwhash_STOREDBYTES.");
        }
        if (passwd == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'passwd' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (master_key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'master_key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (master_key != null && master_key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'master_key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_pwhash_MASTERKEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            int result;
            MemorySegment storedSegment = stored == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, stored);
            MemorySegment passwdSegment = passwd == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, passwd);
            long passwdLength = passwd == null ? 0L : (long)passwd.length;
            MemorySegment masterkeySegment = master_key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, master_key);
            int n = result = HYDRO_PWHASH_VERIFY_HANDLE.invokeExact(storedSegment, passwdSegment, passwdLength, masterkeySegment, opslimit_max, memlimit_max, threads_max);
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_pwhash_verify", e);
            }
        }
    }

    public static int hydro_pwhash_derive_static_key(byte[] static_key, byte[] stored, byte[] passwd, byte[] ctx, byte[] master_key, long opslimit_max, int memlimit_max, byte threads_max) {
        if (static_key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'static_key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (stored == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'stored' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (stored != null && stored.length != 128) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'stored' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_pwhash_STOREDBYTES.");
        }
        if (passwd == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'passwd' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx != null && ctx.length != 8) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_pwhash_CONTEXTBYTES.");
        }
        if (master_key != null && master_key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'master_key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_pwhash_MASTERKEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment statickeySegment = static_key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, static_key);
            long static_keyLength = static_key == null ? 0L : (long)static_key.length;
            MemorySegment storedSegment = stored == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, stored);
            MemorySegment passwdSegment = passwd == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, passwd);
            long passwdLength = passwd == null ? 0L : (long)passwd.length;
            MemorySegment ctxSegment = ctx == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, ctx);
            MemorySegment masterkeySegment = master_key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, master_key);
            int result = HYDRO_PWHASH_DERIVE_STATIC_KEY_HANDLE.invokeExact(statickeySegment, static_keyLength, storedSegment, passwdSegment, passwdLength, ctxSegment, masterkeySegment, opslimit_max, memlimit_max, threads_max);
            if (static_key != null) {
                MemorySegment.copy(statickeySegment, 0L, MemorySegment.ofArray(static_key), 0L, static_key.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_pwhash_derive_static_key", e);
            }
        }
    }

    public static int hydro_pwhash_reencrypt(byte[] stored, byte[] master_key, byte[] new_master_key) {
        if (stored == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'stored' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (stored != null && stored.length != 128) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'stored' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_pwhash_STOREDBYTES.");
        }
        if (master_key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'master_key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (master_key != null && master_key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'master_key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_pwhash_MASTERKEYBYTES.");
        }
        if (new_master_key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'new_master_key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (new_master_key != null && new_master_key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'new_master_key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_pwhash_MASTERKEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment storedSegment = stored == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, stored);
            MemorySegment masterkeySegment = master_key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, master_key);
            MemorySegment newmasterkeySegment = new_master_key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, new_master_key);
            int result = HYDRO_PWHASH_REENCRYPT_HANDLE.invokeExact(storedSegment, masterkeySegment, newmasterkeySegment);
            if (stored != null) {
                MemorySegment.copy(storedSegment, 0L, MemorySegment.ofArray(stored), 0L, stored.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_pwhash_reencrypt", e);
            }
        }
    }

    public static int hydro_pwhash_upgrade(byte[] stored, byte[] master_key, long opslimit, int memlimit, byte threads) {
        if (stored == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'stored' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (stored != null && stored.length != 128) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'stored' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_pwhash_STOREDBYTES.");
        }
        if (master_key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'master_key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (master_key != null && master_key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'master_key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_pwhash_MASTERKEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment storedSegment = stored == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, stored);
            MemorySegment masterkeySegment = master_key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, master_key);
            int result = HYDRO_PWHASH_UPGRADE_HANDLE.invokeExact(storedSegment, masterkeySegment, opslimit, memlimit, threads);
            if (stored != null) {
                MemorySegment.copy(storedSegment, 0L, MemorySegment.ofArray(stored), 0L, stored.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_pwhash_upgrade", e);
            }
        }
    }

    public static void hydro_secretbox_keygen(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (key != null && key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_secretbox_KEYBYTES.");
        }
        try (Arena arena = Arena.ofConfined();){
            MemorySegment keySegment = key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, key);
            HYDRO_SECRETBOX_KEYGEN_HANDLE.invokeExact(keySegment);
            if (key != null) {
                MemorySegment.copy(keySegment, 0L, MemorySegment.ofArray(key), 0L, key.length);
            }
            return;
        }
        catch (Throwable e) {
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_secretbox_keygen", e);
        }
    }

    public static int hydro_secretbox_encrypt(byte[] c, byte[] m_, long msg_id, byte[] ctx, byte[] key) {
        if (c == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'c' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (m_ == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'm_' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx != null && ctx.length != 8) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_secretbox_CONTEXTBYTES.");
        }
        if (key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (key != null && key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_secretbox_KEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment cSegment = c == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, c);
            MemorySegment mSegment = m_ == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, m_);
            long m_Length = m_ == null ? 0L : (long)m_.length;
            MemorySegment ctxSegment = ctx == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, ctx);
            MemorySegment keySegment = key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, key);
            int result = HYDRO_SECRETBOX_ENCRYPT_HANDLE.invokeExact(cSegment, mSegment, m_Length, msg_id, ctxSegment, keySegment);
            if (c != null) {
                MemorySegment.copy(cSegment, 0L, MemorySegment.ofArray(c), 0L, c.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_secretbox_encrypt", e);
            }
        }
    }

    public static int hydro_secretbox_decrypt(byte[] m_, byte[] c, long msg_id, byte[] ctx, byte[] key) {
        if (m_ == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'm_' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (c == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'c' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx != null && ctx.length != 8) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_secretbox_CONTEXTBYTES.");
        }
        if (key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (key != null && key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_secretbox_KEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment mSegment = m_ == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, m_);
            MemorySegment cSegment = c == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, c);
            long cLength = c == null ? 0L : (long)c.length;
            MemorySegment ctxSegment = ctx == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, ctx);
            MemorySegment keySegment = key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, key);
            int result = HYDRO_SECRETBOX_DECRYPT_HANDLE.invokeExact(mSegment, cSegment, cLength, msg_id, ctxSegment, keySegment);
            if (m_ != null) {
                MemorySegment.copy(mSegment, 0L, MemorySegment.ofArray(m_), 0L, m_.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_secretbox_decrypt", e);
            }
        }
    }

    public static void hydro_kdf_keygen(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (key != null && key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kdf_KEYBYTES.");
        }
        try (Arena arena = Arena.ofConfined();){
            MemorySegment keySegment = key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, key);
            HYDRO_KDF_KEYGEN_HANDLE.invokeExact(keySegment);
            if (key != null) {
                MemorySegment.copy(keySegment, 0L, MemorySegment.ofArray(key), 0L, key.length);
            }
            return;
        }
        catch (Throwable e) {
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_kdf_keygen", e);
        }
    }

    public static int hydro_kdf_derive_from_key(byte[] subkey, long subkey_id, byte[] ctx, byte[] key) {
        if (subkey == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'subkey' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx != null && ctx.length != 8) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kdf_CONTEXTBYTES.");
        }
        if (key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (key != null && key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_kdf_KEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment subkeySegment = subkey == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, subkey);
            long subkeyLength = subkey == null ? 0L : (long)subkey.length;
            MemorySegment ctxSegment = ctx == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, ctx);
            MemorySegment keySegment = key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, key);
            int result = HYDRO_KDF_DERIVE_FROM_KEY_HANDLE.invokeExact(subkeySegment, subkeyLength, subkey_id, ctxSegment, keySegment);
            if (subkey != null) {
                MemorySegment.copy(subkeySegment, 0L, MemorySegment.ofArray(subkey), 0L, subkey.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_kdf_derive_from_key", e);
            }
        }
    }

    public static void hydro_sign_keygen(hydro_sign_keypair kp) {
        if (kp == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'kp' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        try (Arena arena = Arena.ofConfined();){
            MemorySegment kpSegment;
            MemorySegment memorySegment = kpSegment = kp == null ? MemorySegment.NULL : arena.allocate(hydro_sign_keypair.getStaticSize());
            if (kp != null) {
                kp.serialize(kpSegment, 0L, arena);
            }
            HYDRO_SIGN_KEYGEN_HANDLE.invokeExact(kpSegment);
            if (kp != null) {
                kp.deserialize(kpSegment, 0L);
            }
            return;
        }
        catch (Throwable e) {
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_sign_keygen", e);
        }
    }

    public static void hydro_sign_keygen_deterministic(hydro_sign_keypair kp, byte[] seed) {
        if (kp == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'kp' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (seed == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'seed' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (seed != null && seed.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'seed' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_sign_SEEDBYTES.");
        }
        try (Arena arena = Arena.ofConfined();){
            MemorySegment kpSegment;
            MemorySegment memorySegment = kpSegment = kp == null ? MemorySegment.NULL : arena.allocate(hydro_sign_keypair.getStaticSize());
            if (kp != null) {
                kp.serialize(kpSegment, 0L, arena);
            }
            MemorySegment seedSegment = seed == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, seed);
            HYDRO_SIGN_KEYGEN_DETERMINISTIC_HANDLE.invokeExact(kpSegment, seedSegment);
            if (kp != null) {
                kp.deserialize(kpSegment, 0L);
            }
            return;
        }
        catch (Throwable e) {
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_sign_keygen_deterministic", e);
        }
    }

    public static int hydro_sign_init(hydro_sign_state state, byte[] ctx) {
        if (state == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'state' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx != null && ctx.length != 8) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_sign_CONTEXTBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment stateSegment;
            MemorySegment memorySegment = stateSegment = state == null ? MemorySegment.NULL : arena.allocate(hydro_sign_state.getStaticSize());
            if (state != null) {
                state.serialize(stateSegment, 0L, arena);
            }
            MemorySegment ctxSegment = ctx == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, ctx);
            int result = HYDRO_SIGN_INIT_HANDLE.invokeExact(stateSegment, ctxSegment);
            if (state != null) {
                state.deserialize(stateSegment, 0L);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_sign_init", e);
            }
        }
    }

    public static int hydro_sign_update(hydro_sign_state state, byte[] m_) {
        if (state == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'state' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (m_ == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'm_' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment stateSegment;
            MemorySegment memorySegment = stateSegment = state == null ? MemorySegment.NULL : arena.allocate(hydro_sign_state.getStaticSize());
            if (state != null) {
                state.serialize(stateSegment, 0L, arena);
            }
            MemorySegment mSegment = m_ == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, m_);
            long m_Length = m_ == null ? 0L : (long)m_.length;
            int result = HYDRO_SIGN_UPDATE_HANDLE.invokeExact(stateSegment, mSegment, m_Length);
            if (state != null) {
                state.deserialize(stateSegment, 0L);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_sign_update", e);
            }
        }
    }

    public static int hydro_sign_final_create(hydro_sign_state state, byte[] csig, byte[] sk) {
        if (state == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'state' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (csig == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'csig' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (csig != null && csig.length != 64) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'csig' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_sign_BYTES.");
        }
        if (sk == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'sk' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (sk != null && sk.length != 64) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'sk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_sign_SECRETKEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment stateSegment;
            MemorySegment memorySegment = stateSegment = state == null ? MemorySegment.NULL : arena.allocate(hydro_sign_state.getStaticSize());
            if (state != null) {
                state.serialize(stateSegment, 0L, arena);
            }
            MemorySegment csigSegment = csig == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, csig);
            MemorySegment skSegment = sk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, sk);
            int result = HYDRO_SIGN_FINAL_CREATE_HANDLE.invokeExact(stateSegment, csigSegment, skSegment);
            if (state != null) {
                state.deserialize(stateSegment, 0L);
            }
            if (csig != null) {
                MemorySegment.copy(csigSegment, 0L, MemorySegment.ofArray(csig), 0L, csig.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_sign_final_create", e);
            }
        }
    }

    public static int hydro_sign_final_verify(hydro_sign_state state, byte[] csig, byte[] pk) {
        if (state == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'state' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (csig == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'csig' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (csig != null && csig.length != 64) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'csig' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_sign_BYTES.");
        }
        if (pk == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'pk' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (pk != null && pk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'pk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_sign_PUBLICKEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment stateSegment;
            MemorySegment memorySegment = stateSegment = state == null ? MemorySegment.NULL : arena.allocate(hydro_sign_state.getStaticSize());
            if (state != null) {
                state.serialize(stateSegment, 0L, arena);
            }
            MemorySegment csigSegment = csig == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, csig);
            MemorySegment pkSegment = pk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, pk);
            int result = HYDRO_SIGN_FINAL_VERIFY_HANDLE.invokeExact(stateSegment, csigSegment, pkSegment);
            if (state != null) {
                state.deserialize(stateSegment, 0L);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_sign_final_verify", e);
            }
        }
    }

    public static int hydro_sign_create(byte[] csig, byte[] m_, byte[] ctx, byte[] sk) {
        if (csig == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'csig' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (csig != null && csig.length != 64) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'csig' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_sign_BYTES.");
        }
        if (m_ == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'm_' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx != null && ctx.length != 8) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_sign_CONTEXTBYTES.");
        }
        if (sk == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'sk' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (sk != null && sk.length != 64) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'sk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_sign_SECRETKEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment csigSegment = csig == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, csig);
            MemorySegment mSegment = m_ == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, m_);
            long m_Length = m_ == null ? 0L : (long)m_.length;
            MemorySegment ctxSegment = ctx == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, ctx);
            MemorySegment skSegment = sk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, sk);
            int result = HYDRO_SIGN_CREATE_HANDLE.invokeExact(csigSegment, mSegment, m_Length, ctxSegment, skSegment);
            if (csig != null) {
                MemorySegment.copy(csigSegment, 0L, MemorySegment.ofArray(csig), 0L, csig.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_sign_create", e);
            }
        }
    }

    public static int hydro_sign_verify(byte[] csig, byte[] m_, byte[] ctx, byte[] pk) {
        if (csig == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'csig' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (csig != null && csig.length != 64) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'csig' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_sign_BYTES.");
        }
        if (m_ == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'm_' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ctx != null && ctx.length != 8) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ctx' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_sign_CONTEXTBYTES.");
        }
        if (pk == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'pk' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (pk != null && pk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'pk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 hydro_sign_PUBLICKEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            int result;
            MemorySegment csigSegment = csig == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, csig);
            MemorySegment mSegment = m_ == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, m_);
            long m_Length = m_ == null ? 0L : (long)m_.length;
            MemorySegment ctxSegment = ctx == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, ctx);
            MemorySegment pkSegment = pk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, pk);
            int n = result = HYDRO_SIGN_VERIFY_HANDLE.invokeExact(csigSegment, mSegment, m_Length, ctxSegment, pkSegment);
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 hydro_sign_verify", e);
            }
        }
    }

    static {
        LINKER = Linker.nativeLinker();
        RU.loadLibrary((String)"hydrogen");
        SYMBOL_LOOKUP = SymbolLookup.loaderLookup();
        HYDRO_SECRETBOX_PROBE_CREATE_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_secretbox_probe_create").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_secretbox_probe_create \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_SECRETBOX_PROBE_VERIFY_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_secretbox_probe_verify").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_secretbox_probe_verify \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_HASH_KEYGEN_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_hash_keygen").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_hash_keygen \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.ofVoid(ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_HASH_INIT_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_hash_init").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_hash_init \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_HASH_UPDATE_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_hash_update").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_hash_update \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG), new Linker.Option[0]);
        HYDRO_HASH_FINAL_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_hash_final").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_hash_final \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG), new Linker.Option[0]);
        HYDRO_HASH_HASH_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_hash_hash").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_hash_hash \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_KX_KEYGEN_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_kx_keygen").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_kx_keygen \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.ofVoid(ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_KX_KEYGEN_DETERMINISTIC_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_kx_keygen_deterministic").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_kx_keygen_deterministic \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.ofVoid(ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_KX_N_1_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_kx_n_1").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_kx_n_1 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_KX_KK_1_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_kx_kk_1").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_kx_kk_1 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_KX_N_2_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_kx_n_2").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_kx_n_2 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_KX_KK_2_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_kx_kk_2").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_kx_kk_2 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_KX_KK_3_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_kx_kk_3").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_kx_kk_3 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_KX_XX_1_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_kx_xx_1").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_kx_xx_1 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_KX_XX_2_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_kx_xx_2").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_kx_xx_2 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_KX_XX_3_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_kx_xx_3").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_kx_xx_3 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_KX_XX_4_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_kx_xx_4").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_kx_xx_4 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_KX_NK_1_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_kx_nk_1").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_kx_nk_1 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_KX_NK_2_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_kx_nk_2").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_kx_nk_2 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_KX_NK_3_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_kx_nk_3").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_kx_nk_3 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_PWHASH_KEYGEN_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_pwhash_keygen").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_pwhash_keygen \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.ofVoid(ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_PWHASH_DETERMINISTIC_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_pwhash_deterministic").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_pwhash_deterministic \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.JAVA_BYTE), new Linker.Option[0]);
        HYDRO_PWHASH_CREATE_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_pwhash_create").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_pwhash_create \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.JAVA_BYTE), new Linker.Option[0]);
        HYDRO_PWHASH_VERIFY_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_pwhash_verify").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_pwhash_verify \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.JAVA_BYTE), new Linker.Option[0]);
        HYDRO_PWHASH_DERIVE_STATIC_KEY_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_pwhash_derive_static_key").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_pwhash_derive_static_key \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.JAVA_BYTE), new Linker.Option[0]);
        HYDRO_PWHASH_REENCRYPT_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_pwhash_reencrypt").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_pwhash_reencrypt \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_PWHASH_UPGRADE_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_pwhash_upgrade").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_pwhash_upgrade \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.JAVA_BYTE), new Linker.Option[0]);
        HYDRO_SECRETBOX_KEYGEN_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_secretbox_keygen").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_secretbox_keygen \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.ofVoid(ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_SECRETBOX_ENCRYPT_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_secretbox_encrypt").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_secretbox_encrypt \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_SECRETBOX_DECRYPT_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_secretbox_decrypt").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_secretbox_decrypt \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_KDF_KEYGEN_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_kdf_keygen").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_kdf_keygen \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.ofVoid(ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_KDF_DERIVE_FROM_KEY_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_kdf_derive_from_key").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_kdf_derive_from_key \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_SIGN_KEYGEN_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_sign_keygen").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_sign_keygen \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.ofVoid(ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_SIGN_KEYGEN_DETERMINISTIC_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_sign_keygen_deterministic").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_sign_keygen_deterministic \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.ofVoid(ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_SIGN_INIT_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_sign_init").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_sign_init \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_SIGN_UPDATE_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_sign_update").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_sign_update \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG), new Linker.Option[0]);
        HYDRO_SIGN_FINAL_CREATE_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_sign_final_create").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_sign_final_create \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_SIGN_FINAL_VERIFY_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_sign_final_verify").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_sign_final_verify \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_SIGN_CREATE_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_sign_create").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_sign_create \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        HYDRO_SIGN_VERIFY_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("hydro_sign_verify").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 hydro_sign_verify \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
    }

    public static class hydro_hash_state {
        public int[] state;
        public byte buf_off;
        public byte[] align;

        public hydro_hash_state() {
            this.state = new int[12];
            this.align = new byte[3];
        }

        public hydro_hash_state(int[] state, byte buf_off, byte[] align) {
            this.state = state;
            this.buf_off = buf_off;
            this.align = align;
        }

        public int[] getState() {
            return this.state;
        }

        public byte getBuf_off() {
            return this.buf_off;
        }

        public byte[] getAlign() {
            return this.align;
        }

        public long serialize(MemorySegment segment, long offset, Arena arena) {
            long currentOffset = offset;
            for (int i = 0; i < this.state.length; ++i) {
                segment.set(ValueLayout.JAVA_INT, currentOffset + (long)(i * 4), this.state[i]);
            }
            segment.set(ValueLayout.JAVA_BYTE, currentOffset += (long)(4 * this.state.length), this.buf_off);
            MemorySegment.copy(MemorySegment.ofArray(this.align), 0L, segment, ++currentOffset, this.align.length);
            return currentOffset += (long)(1 * this.align.length);
        }

        public void deserialize(MemorySegment segment, long offset) {
            long currentOffset = offset;
            for (int i = 0; i < this.state.length; ++i) {
                this.state[i] = segment.get(ValueLayout.JAVA_INT, currentOffset + (long)(i * 4));
            }
            this.buf_off = segment.get(ValueLayout.JAVA_BYTE, currentOffset += (long)(4 * this.state.length));
            MemorySegment.copy(segment, ++currentOffset, MemorySegment.ofArray(this.align), 0L, this.align.length);
            currentOffset += (long)(1 * this.align.length);
        }

        public int getSerializedSize() {
            return 52;
        }

        public static int getStaticSize() {
            return 52;
        }
    }

    public static class hydro_kx_keypair {
        public byte[] pk;
        public byte[] sk;

        public hydro_kx_keypair() {
            this.pk = new byte[32];
            this.sk = new byte[32];
        }

        public hydro_kx_keypair(byte[] pk, byte[] sk) {
            this.pk = pk;
            this.sk = sk;
        }

        public byte[] getPk() {
            return this.pk;
        }

        public byte[] getSk() {
            return this.sk;
        }

        public long serialize(MemorySegment segment, long offset, Arena arena) {
            long currentOffset = offset;
            MemorySegment.copy(MemorySegment.ofArray(this.pk), 0L, segment, currentOffset, this.pk.length);
            MemorySegment.copy(MemorySegment.ofArray(this.sk), 0L, segment, currentOffset += (long)(1 * this.pk.length), this.sk.length);
            return currentOffset += (long)(1 * this.sk.length);
        }

        public void deserialize(MemorySegment segment, long offset) {
            long currentOffset = offset;
            MemorySegment.copy(segment, currentOffset, MemorySegment.ofArray(this.pk), 0L, this.pk.length);
            MemorySegment.copy(segment, currentOffset += (long)(1 * this.pk.length), MemorySegment.ofArray(this.sk), 0L, this.sk.length);
            currentOffset += (long)(1 * this.sk.length);
        }

        public int getSerializedSize() {
            return 64;
        }

        public static int getStaticSize() {
            return 64;
        }
    }

    public static class hydro_kx_session_keypair {
        public byte[] rx;
        public byte[] tx;

        public hydro_kx_session_keypair() {
            this.rx = new byte[32];
            this.tx = new byte[32];
        }

        public hydro_kx_session_keypair(byte[] rx, byte[] tx) {
            this.rx = rx;
            this.tx = tx;
        }

        public byte[] getRx() {
            return this.rx;
        }

        public byte[] getTx() {
            return this.tx;
        }

        public long serialize(MemorySegment segment, long offset, Arena arena) {
            long currentOffset = offset;
            MemorySegment.copy(MemorySegment.ofArray(this.rx), 0L, segment, currentOffset, this.rx.length);
            MemorySegment.copy(MemorySegment.ofArray(this.tx), 0L, segment, currentOffset += (long)(1 * this.rx.length), this.tx.length);
            return currentOffset += (long)(1 * this.tx.length);
        }

        public void deserialize(MemorySegment segment, long offset) {
            long currentOffset = offset;
            MemorySegment.copy(segment, currentOffset, MemorySegment.ofArray(this.rx), 0L, this.rx.length);
            MemorySegment.copy(segment, currentOffset += (long)(1 * this.rx.length), MemorySegment.ofArray(this.tx), 0L, this.tx.length);
            currentOffset += (long)(1 * this.tx.length);
        }

        public int getSerializedSize() {
            return 64;
        }

        public static int getStaticSize() {
            return 64;
        }
    }

    public static class hydro_kx_state {
        public hydro_kx_keypair eph_kp;
        public hydro_hash_state h_st;

        public hydro_kx_state() {
        }

        public hydro_kx_state(hydro_kx_keypair eph_kp, hydro_hash_state h_st) {
            this.eph_kp = eph_kp;
            this.h_st = h_st;
        }

        public hydro_kx_keypair getEph_kp() {
            return this.eph_kp;
        }

        public hydro_hash_state getH_st() {
            return this.h_st;
        }

        public long serialize(MemorySegment segment, long offset, Arena arena) {
            long currentOffset = offset;
            this.eph_kp.serialize(segment, currentOffset, arena);
            this.h_st.serialize(segment, currentOffset += (long)this.eph_kp.getSerializedSize(), arena);
            return currentOffset += (long)this.h_st.getSerializedSize();
        }

        public void deserialize(MemorySegment segment, long offset) {
            long currentOffset = offset;
            this.eph_kp.deserialize(segment, currentOffset);
            this.h_st.deserialize(segment, currentOffset += (long)this.eph_kp.getSerializedSize());
            currentOffset += (long)this.h_st.getSerializedSize();
        }

        public int getSerializedSize() {
            return 116;
        }

        public static int getStaticSize() {
            return 116;
        }
    }

    public static class hydro_sign_keypair {
        public byte[] pk;
        public byte[] sk;

        public hydro_sign_keypair() {
            this.pk = new byte[32];
            this.sk = new byte[64];
        }

        public hydro_sign_keypair(byte[] pk, byte[] sk) {
            this.pk = pk;
            this.sk = sk;
        }

        public byte[] getPk() {
            return this.pk;
        }

        public byte[] getSk() {
            return this.sk;
        }

        public long serialize(MemorySegment segment, long offset, Arena arena) {
            long currentOffset = offset;
            MemorySegment.copy(MemorySegment.ofArray(this.pk), 0L, segment, currentOffset, this.pk.length);
            MemorySegment.copy(MemorySegment.ofArray(this.sk), 0L, segment, currentOffset += (long)(1 * this.pk.length), this.sk.length);
            return currentOffset += (long)(1 * this.sk.length);
        }

        public void deserialize(MemorySegment segment, long offset) {
            long currentOffset = offset;
            MemorySegment.copy(segment, currentOffset, MemorySegment.ofArray(this.pk), 0L, this.pk.length);
            MemorySegment.copy(segment, currentOffset += (long)(1 * this.pk.length), MemorySegment.ofArray(this.sk), 0L, this.sk.length);
            currentOffset += (long)(1 * this.sk.length);
        }

        public int getSerializedSize() {
            return 96;
        }

        public static int getStaticSize() {
            return 96;
        }
    }

    public static class hydro_sign_state {
        public hydro_hash_state hash_st;

        public hydro_sign_state() {
        }

        public hydro_sign_state(hydro_hash_state hash_st) {
            this.hash_st = hash_st;
        }

        public hydro_hash_state getHash_st() {
            return this.hash_st;
        }

        public long serialize(MemorySegment segment, long offset, Arena arena) {
            long currentOffset = offset;
            this.hash_st.serialize(segment, currentOffset, arena);
            return currentOffset += (long)this.hash_st.getSerializedSize();
        }

        public void deserialize(MemorySegment segment, long offset) {
            long currentOffset = offset;
            this.hash_st.deserialize(segment, currentOffset);
            currentOffset += (long)this.hash_st.getSerializedSize();
        }

        public int getSerializedSize() {
            return 52;
        }

        public static int getStaticSize() {
            return 52;
        }
    }
}

