/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto.sodium;

import io.aether.crypto.AKey;
import io.aether.crypto.CryptoEngine;
import io.aether.crypto.CryptoProvider;
import io.aether.crypto.DecryptException;
import io.aether.crypto.EncryptException;
import io.aether.crypto.sodium.SodiumCryptoProvider;
import io.aether.nativeLib.SodiumLib;

public class SodiumAsymmetricEngine
implements CryptoEngine {
    private final AKey.AsymmetricPublic publicKey;
    private final AKey.AsymmetricPrivate privateKey;
    private static final int CRYPTO_BOX_NONCEBYTES = 24;
    private static final int CRYPTO_BOX_MACBYTES = 16;

    public SodiumAsymmetricEngine(AKey.AsymmetricPublic publicKey) {
        this.publicKey = publicKey;
        this.privateKey = null;
    }

    public SodiumAsymmetricEngine(AKey.AsymmetricPrivate privateKey, AKey.AsymmetricPublic publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public byte[] encrypt(byte[] data) {
        byte[] nonce = new byte[24];
        byte[] result = new byte[data.length + 16];
        if (this.privateKey == null) {
            throw new UnsupportedOperationException("This engine is not configured for encryption.");
        }
        if (0 != SodiumLib.crypto_box_easy(result, data, nonce, this.publicKey.getData(), this.privateKey.getData())) {
            throw new EncryptException();
        }
        return SodiumAsymmetricEngine.addArray(nonce, result);
    }

    public byte[] decrypt(byte[] data) {
        byte[] nonce = new byte[24];
        System.arraycopy(data, 0, nonce, 0, 24);
        byte[] encryptedData = new byte[data.length - 24];
        System.arraycopy(data, 24, encryptedData, 0, encryptedData.length);
        byte[] result = new byte[encryptedData.length - 16];
        if (this.privateKey == null) {
            throw new UnsupportedOperationException("This engine is not configured for decryption.");
        }
        if (0 != SodiumLib.crypto_box_open_easy(result, encryptedData, nonce, this.publicKey.getData(), this.privateKey.getData())) {
            throw new DecryptException();
        }
        return result;
    }

    private static byte[] addArray(byte[] a1, byte[] a2) {
        byte[] res = new byte[a1.length + a2.length];
        System.arraycopy(a1, 0, res, 0, a1.length);
        System.arraycopy(a2, 0, res, a1.length, a2.length);
        return res;
    }

    public CryptoProvider getCryptoProvider() {
        return SodiumCryptoProvider.INSTANCE;
    }

    public String getProviderName() {
        return "SODIUM";
    }
}

