/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto.sodium;

import io.aether.crypto.AKey;
import io.aether.crypto.CryptoEngine;
import io.aether.crypto.CryptoProvider;
import io.aether.crypto.KeyType;
import io.aether.crypto.PairAsymKeys;
import io.aether.crypto.PairSignKeys;
import io.aether.crypto.PairSymKeys;
import io.aether.crypto.Sign;
import io.aether.crypto.Signer;
import io.aether.crypto.sodium.SodiumAsymmetricEngine;
import io.aether.crypto.sodium.SodiumKey;
import io.aether.crypto.sodium.SodiumSign;
import io.aether.crypto.sodium.SodiumSigner;
import io.aether.crypto.sodium.SodiumSymmetricEngine;
import io.aether.nativeLib.SodiumLib;
import io.aether.utils.HexUtils;
import io.aether.utils.RU;

public class SodiumCryptoProvider
implements CryptoProvider {
    public static final SodiumCryptoProvider INSTANCE = new SodiumCryptoProvider();
    private static final int CRYPTO_SECRETBOX_KEYBYTES = 32;
    private static final int CRYPTO_BOX_PUBLICKEYBYTES = 32;
    private static final int CRYPTO_BOX_SECRETKEYBYTES = 32;
    private static final int CRYPTO_SIGN_PUBLICKEYBYTES = 32;
    private static final int CRYPTO_SIGN_SECRETKEYBYTES = 64;

    private SodiumCryptoProvider() {
    }

    public AKey.SignPublic createSignPublicKey(byte[] data) {
        return new SodiumKey.SignPublic(data);
    }

    public AKey.SignPrivate createSignPrivateKey(byte[] data) {
        return new SodiumKey.SignPrivate(data);
    }

    public AKey.Symmetric createSymmetricKey(byte[] data) {
        return new SodiumKey.Symmetric(data);
    }

    public String getCryptoLibName() {
        return "SODIUM";
    }

    public PairAsymKeys createAsymmetricKeys() {
        SodiumLib.crypto_box_keypair keys = new SodiumLib.crypto_box_keypair();
        SodiumLib.crypto_box_keypair(keys);
        return new PairAsymKeys((AKey.AsymmetricPublic)new SodiumKey.AsymmetricPublic(keys.pk), (AKey.AsymmetricPrivate)new SodiumKey.AsymmetricPrivate(keys.sk));
    }

    public AKey.Symmetric createSymmetricKey() {
        byte[] key = new byte[32];
        SodiumLib.crypto_secretbox_keygen(key);
        return new SodiumKey.Symmetric(key);
    }

    public PairSignKeys createSignKeys() {
        SodiumLib.crypto_sign_keypair keys = new SodiumLib.crypto_sign_keypair();
        SodiumLib.crypto_sign_keypair(keys);
        return new PairSignKeys((AKey.SignPublic)new SodiumKey.SignPublic(keys.pk), (AKey.SignPrivate)new SodiumKey.SignPrivate(keys.sk));
    }

    public Signer createSigner(PairSignKeys keys) {
        return this.createSigner(keys.publicKey, keys.privateKey);
    }

    public Signer createSigner(AKey.SignPublic publicKey, AKey.SignPrivate privateKey) {
        if (!(publicKey instanceof SodiumKey.SignPublic) || !(privateKey instanceof SodiumKey.SignPrivate)) {
            throw new IllegalArgumentException("Keys must be instances of SodiumKey.SignPublic and SodiumKey.SignPrivate");
        }
        return new SodiumSigner(publicKey, privateKey);
    }

    public Signer createSigner(AKey.SignPublic publicKey) {
        if (!(publicKey instanceof SodiumKey.SignPublic)) {
            throw new IllegalArgumentException("Public key must be an instance of SodiumKey.SignPublic");
        }
        return new SodiumSigner(publicKey, null);
    }

    public CryptoEngine createSymmetricEngine(AKey.Symmetric key) {
        if (!(key instanceof SodiumKey.Symmetric)) {
            throw new IllegalArgumentException("Key must be a SodiumKey.Symmetric instance");
        }
        return new SodiumSymmetricEngine(key);
    }

    public CryptoEngine createAsymmetricEngine(AKey.AsymmetricPublic key) {
        if (!(key instanceof SodiumKey.AsymmetricPublic)) {
            throw new IllegalArgumentException("Key must be a SodiumKey.AsymmetricPublic instance");
        }
        return new SodiumAsymmetricEngine(key);
    }

    public CryptoEngine createAsymmetricEngine(AKey.AsymmetricPrivate privateKey, AKey.AsymmetricPublic publicKey) {
        if (!(privateKey instanceof SodiumKey.AsymmetricPrivate) || !(publicKey instanceof SodiumKey.AsymmetricPublic)) {
            throw new IllegalArgumentException("Keys must be instances of SodiumKey.AsymmetricPrivate and SodiumKey.AsymmetricPublic");
        }
        return new SodiumAsymmetricEngine(privateKey, publicKey);
    }

    public CryptoEngine createAsymmetricEngine(PairAsymKeys keys) {
        return this.createAsymmetricEngine(keys.getPrivateKey(), keys.getPublicKey());
    }

    public <T extends AKey> T createKey(KeyType keyType, byte[] data) {
        return (T)(switch (keyType) {
            default -> throw new MatchException(null, null);
            case KeyType.SYMMETRIC -> (AKey)RU.cast((Object)new SodiumKey.Symmetric(data));
            case KeyType.ASYMMETRIC_PUBLIC -> (AKey)RU.cast((Object)new SodiumKey.AsymmetricPublic(data));
            case KeyType.ASYMMETRIC_PRIVATE -> (AKey)RU.cast((Object)new SodiumKey.AsymmetricPrivate(data));
            case KeyType.SIGN_PUBLIC -> (AKey)RU.cast((Object)new SodiumKey.SignPublic(data));
            case KeyType.SIGN_PRIVATE -> (AKey)RU.cast((Object)new SodiumKey.SignPrivate(data));
        });
    }

    public <T extends AKey> T createKey(String data) {
        String[] parts = data.split(":");
        if (parts.length != 3 || !parts[0].equals(this.getCryptoLibName())) {
            throw new IllegalArgumentException("Invalid key string for this provider.");
        }
        KeyType keyType = KeyType.valueOf((String)parts[1]);
        byte[] bytes = HexUtils.hexToBytes((CharSequence)parts[2]);
        return this.createKey(keyType, bytes);
    }

    public Sign createSign(String data) {
        String[] parts = data.split(":");
        if (parts.length != 2 || !parts[0].equals(this.getCryptoLibName())) {
            throw new IllegalArgumentException("Invalid sign string for this provider.");
        }
        return new SodiumSign(HexUtils.hexToBytes((CharSequence)parts[1]));
    }

    public Sign createSign(byte[] data) {
        return new SodiumSign(data);
    }

    public PairSymKeys deriveSymmetricKeys(AKey.Symmetric masterKey, int serverId, int keyNumber) {
        throw new UnsupportedOperationException();
    }
}

