/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto.sodium;

import io.aether.crypto.CryptoProvider;
import io.aether.crypto.Sign;
import io.aether.crypto.sodium.SodiumCryptoProvider;
import io.aether.utils.HexUtils;

public class SodiumSign
implements Sign {
    private static final int SIGNATURE_LENGTH = 64;
    private final byte[] data;

    public SodiumSign(byte[] data) {
        if (data == null) {
            throw new NullPointerException("Signature data cannot be null.");
        }
        if (data.length != 64) {
            throw new IllegalArgumentException("Invalid signature length for SODIUM. Expected 64 bytes, but got " + data.length + " bytes.");
        }
        this.data = data;
    }

    public byte[] getSignData() {
        return this.data;
    }

    public String toString() {
        return this.getProviderName() + ":" + HexUtils.toHexString((byte[])this.getSignData());
    }

    public CryptoProvider getCryptoProvider() {
        return SodiumCryptoProvider.INSTANCE;
    }
}

