/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto.sodium;

import io.aether.crypto.AKey;
import io.aether.crypto.CryptoEngine;
import io.aether.crypto.CryptoProvider;
import io.aether.crypto.DecryptException;
import io.aether.crypto.EncryptException;
import io.aether.crypto.sodium.SodiumCryptoProvider;
import io.aether.nativeLib.SodiumLib;

public class SodiumSymmetricEngine
implements CryptoEngine {
    private final AKey.Symmetric key;
    private static final int CRYPTO_SECRETBOX_NONCEBYTES = 24;
    private static final int CRYPTO_SECRETBOX_MACBYTES = 16;

    public SodiumSymmetricEngine(AKey.Symmetric key) {
        this.key = key;
    }

    public byte[] encrypt(byte[] data) {
        byte[] result = new byte[data.length + 16];
        byte[] nonce = new byte[24];
        if (0 != SodiumLib.crypto_secretbox_easy(result, data, nonce, this.key.getData())) {
            throw new EncryptException();
        }
        return SodiumSymmetricEngine.addArray(nonce, result);
    }

    public byte[] decrypt(byte[] data) {
        byte[] nonce = new byte[24];
        System.arraycopy(data, 0, nonce, 0, 24);
        byte[] encryptedData = new byte[data.length - 24];
        System.arraycopy(data, 24, encryptedData, 0, encryptedData.length);
        byte[] result = new byte[encryptedData.length - 16];
        if (0 != SodiumLib.crypto_secretbox_open_easy(result, encryptedData, nonce, this.key.getData())) {
            throw new DecryptException();
        }
        return result;
    }

    private static byte[] addArray(byte[] a1, byte[] a2) {
        byte[] res = new byte[a1.length + a2.length];
        System.arraycopy(a1, 0, res, 0, a1.length);
        System.arraycopy(a2, 0, res, a1.length, a2.length);
        return res;
    }

    public String getProviderName() {
        return "SODIUM";
    }

    public CryptoProvider getCryptoProvider() {
        return SodiumCryptoProvider.INSTANCE;
    }
}

