package io.aether.crypto.sodium;

import io.aether.crypto.Sign;
import io.aether.crypto.CryptoProvider;
import io.aether.utils.HexUtils;

public class SodiumSign implements Sign {
    private static final int SIGNATURE_LENGTH = 64;
    private final byte[] data;

    public SodiumSign(byte[] data) {
        if (data == null) {
            throw new NullPointerException("Signature data cannot be null.");
        }
        if (data.length != SIGNATURE_LENGTH) {
            throw new IllegalArgumentException(
                    "Invalid signature length for SODIUM. Expected " + SIGNATURE_LENGTH + " bytes, but got " + data.length + " bytes."
            );
        }
        this.data = data;
    }

    @Override
    public byte[] getSignData() {
        return data;
    }

    @Override
    public String toString() {
        return getProviderName() + ":" + HexUtils.toHexString(getSignData());
    }

    @Override
    public CryptoProvider getCryptoProvider() {
        return SodiumCryptoProvider.INSTANCE;
    }
}