/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto.sodium;

import io.aether.crypto.AKey;
import io.aether.crypto.CryptoProvider;
import io.aether.crypto.Sign;
import io.aether.crypto.Signer;
import io.aether.crypto.sodium.SodiumCryptoProvider;
import io.aether.crypto.sodium.SodiumSign;
import io.aether.nativeLib.SodiumLib;

public class SodiumSigner
implements Signer {
    private final AKey.SignPublic publicKey;
    private final AKey.SignPrivate privateKey;
    private static final int CRYPTO_SIGN_BYTES = 64;

    public SodiumSigner(AKey.SignPublic publicKey, AKey.SignPrivate privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public Sign sign(byte[] data) {
        if (this.privateKey == null) {
            throw new IllegalStateException("This Signer instance is not configured with a private key for signing.");
        }
        byte[] sign = new byte[64];
        SodiumLib.crypto_sign_detached(sign, data, this.privateKey.getData());
        return new SodiumSign(sign);
    }

    public boolean checkSign(byte[] data, Sign sign) {
        if (!(sign instanceof SodiumSign)) {
            throw new IllegalArgumentException("Sign must be a SodiumSign instance");
        }
        if (this.publicKey == null) {
            throw new IllegalStateException("This Signer instance is not configured with a public key for checking.");
        }
        return SodiumLib.crypto_sign_verify_detached(sign.getSignData(), data, this.publicKey.getData()) == 0;
    }

    public AKey.SignPublic getPublicKey() {
        return this.publicKey;
    }

    public String getProviderName() {
        return "SODIUM";
    }

    public CryptoProvider getCryptoProvider() {
        return SodiumCryptoProvider.INSTANCE;
    }
}

