/*
 * Decompiled with CFR 0.152.
 */
package io.aether.nativeLib;

import io.aether.utils.RU;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.nio.charset.StandardCharsets;

public final class SodiumLib {
    public static final int crypto_box_PUBLICKEYBYTES = 32;
    public static final int crypto_box_SECRETKEYBYTES = 32;
    public static final int crypto_box_NONCEBYTES = 24;
    public static final int crypto_box_MACBYTES = 16;
    public static final int crypto_secretbox_KEYBYTES = 32;
    public static final int crypto_secretbox_NONCEBYTES = 24;
    public static final int crypto_secretbox_MACBYTES = 16;
    public static final int crypto_auth_KEYBYTES = 32;
    public static final int crypto_auth_BYTES = 32;
    public static final int crypto_sign_PUBLICKEYBYTES = 32;
    public static final int crypto_sign_SECRETKEYBYTES = 64;
    public static final int crypto_sign_BYTES = 64;
    public static final int crypto_sign_SEEDBYTES = 32;
    public static final int crypto_generichash_BYTES = 32;
    public static final int crypto_generichash_BYTES_MIN = 16;
    public static final int crypto_generichash_BYTES_MAX = 64;
    public static final int crypto_generichash_KEYBYTES = 32;
    public static final int crypto_generichash_KEYBYTES_MIN = 16;
    public static final int crypto_generichash_KEYBYTES_MAX = 64;
    public static final int sodium_bin2hex_BUF_LEN = 32;
    public static final int sodium_bin2hex_LEN_MULT = 2;
    public static final int sodium_hex2bin_BUF_LEN = 16;
    private static final MethodHandle CRYPTO_BOX_KEYPAIR_HANDLE;
    private static final MethodHandle CRYPTO_BOX_EASY_HANDLE;
    private static final MethodHandle CRYPTO_BOX_OPEN_EASY_HANDLE;
    private static final MethodHandle CRYPTO_SECRETBOX_KEYGEN_HANDLE;
    private static final MethodHandle CRYPTO_SECRETBOX_EASY_HANDLE;
    private static final MethodHandle CRYPTO_SECRETBOX_OPEN_EASY_HANDLE;
    private static final MethodHandle CRYPTO_SIGN_KEYPAIR_HANDLE;
    private static final MethodHandle CRYPTO_SIGN_HANDLE;
    private static final MethodHandle CRYPTO_SIGN_OPEN_HANDLE;
    private static final MethodHandle CRYPTO_SIGN_DETACHED_HANDLE;
    private static final MethodHandle CRYPTO_SIGN_VERIFY_DETACHED_HANDLE;
    private static final MethodHandle CRYPTO_GENERICHASH_HANDLE;
    private static final MethodHandle CRYPTO_GENERICHASH_INIT_HANDLE;
    private static final MethodHandle CRYPTO_GENERICHASH_UPDATE_HANDLE;
    private static final MethodHandle CRYPTO_GENERICHASH_FINAL_HANDLE;
    private static final MethodHandle CRYPTO_AUTH_KEYGEN_HANDLE;
    private static final MethodHandle CRYPTO_AUTH_HANDLE;
    private static final MethodHandle CRYPTO_AUTH_VERIFY_HANDLE;
    private static final MethodHandle SODIUM_BIN2HEX_HANDLE;
    private static final MethodHandle SODIUM_HEX2BIN_HANDLE;
    private static final Linker LINKER;
    private static final SymbolLookup SYMBOL_LOOKUP;

    public static int crypto_box_keypair(crypto_box_keypair keypair) {
        if (keypair == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'keypair' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment keypairSegment;
            MemorySegment memorySegment = keypairSegment = keypair == null ? MemorySegment.NULL : arena.allocate(crypto_box_keypair.getStaticSize());
            if (keypair != null) {
                keypair.serialize(keypairSegment, 0L, arena);
            }
            int result = CRYPTO_BOX_KEYPAIR_HANDLE.invokeExact(keypairSegment);
            if (keypair != null) {
                keypair.deserialize(keypairSegment, 0L);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 crypto_box_keypair", e);
            }
        }
    }

    public static int crypto_box_easy(byte[] c, byte[] m, byte[] n, byte[] pk, byte[] sk) {
        if (c == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'c' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (m == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'm' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (n == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'n' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (n != null && n.length != 24) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'n' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_box_NONCEBYTES.");
        }
        if (pk == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'pk' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (pk != null && pk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'pk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_box_PUBLICKEYBYTES.");
        }
        if (sk == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'sk' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (sk != null && sk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'sk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_box_SECRETKEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment cSegment = c == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, c);
            MemorySegment mSegment = m == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, m);
            MemorySegment nSegment = n == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, n);
            MemorySegment pkSegment = pk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, pk);
            MemorySegment skSegment = sk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, sk);
            int result = CRYPTO_BOX_EASY_HANDLE.invokeExact(cSegment, mSegment, nSegment, pkSegment, skSegment);
            if (c != null) {
                MemorySegment.copy(cSegment, 0L, MemorySegment.ofArray(c), 0L, c.length);
            }
            if (m != null) {
                MemorySegment.copy(mSegment, 0L, MemorySegment.ofArray(m), 0L, m.length);
            }
            if (n != null) {
                MemorySegment.copy(nSegment, 0L, MemorySegment.ofArray(n), 0L, n.length);
            }
            if (pk != null) {
                MemorySegment.copy(pkSegment, 0L, MemorySegment.ofArray(pk), 0L, pk.length);
            }
            if (sk != null) {
                MemorySegment.copy(skSegment, 0L, MemorySegment.ofArray(sk), 0L, sk.length);
            }
            int n2 = result;
            if (arena != null) {
                arena.close();
            }
            return n2;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 crypto_box_easy", e);
            }
        }
    }

    public static int crypto_box_open_easy(byte[] m, byte[] c, byte[] n, byte[] pk, byte[] sk) {
        if (m == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'm' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (c == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'c' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (n == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'n' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (n != null && n.length != 24) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'n' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_box_NONCEBYTES.");
        }
        if (pk == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'pk' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (pk != null && pk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'pk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_box_PUBLICKEYBYTES.");
        }
        if (sk == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'sk' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (sk != null && sk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'sk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_box_SECRETKEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment mSegment = m == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, m);
            MemorySegment cSegment = c == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, c);
            MemorySegment nSegment = n == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, n);
            MemorySegment pkSegment = pk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, pk);
            MemorySegment skSegment = sk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, sk);
            int result = CRYPTO_BOX_OPEN_EASY_HANDLE.invokeExact(mSegment, cSegment, nSegment, pkSegment, skSegment);
            if (m != null) {
                MemorySegment.copy(mSegment, 0L, MemorySegment.ofArray(m), 0L, m.length);
            }
            if (c != null) {
                MemorySegment.copy(cSegment, 0L, MemorySegment.ofArray(c), 0L, c.length);
            }
            if (n != null) {
                MemorySegment.copy(nSegment, 0L, MemorySegment.ofArray(n), 0L, n.length);
            }
            if (pk != null) {
                MemorySegment.copy(pkSegment, 0L, MemorySegment.ofArray(pk), 0L, pk.length);
            }
            if (sk != null) {
                MemorySegment.copy(skSegment, 0L, MemorySegment.ofArray(sk), 0L, sk.length);
            }
            int n2 = result;
            if (arena != null) {
                arena.close();
            }
            return n2;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 crypto_box_open_easy", e);
            }
        }
    }

    public static int crypto_secretbox_keygen(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (key != null && key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_secretbox_KEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment keySegment = key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, key);
            int result = CRYPTO_SECRETBOX_KEYGEN_HANDLE.invokeExact(keySegment);
            if (key != null) {
                MemorySegment.copy(keySegment, 0L, MemorySegment.ofArray(key), 0L, key.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 crypto_secretbox_keygen", e);
            }
        }
    }

    public static int crypto_secretbox_easy(byte[] c, byte[] m, byte[] n, byte[] k) {
        if (c == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'c' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (m == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'm' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (n == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'n' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (n != null && n.length != 24) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'n' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_secretbox_NONCEBYTES.");
        }
        if (k == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'k' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (k != null && k.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'k' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_secretbox_KEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment cSegment = c == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, c);
            MemorySegment mSegment = m == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, m);
            MemorySegment nSegment = n == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, n);
            MemorySegment kSegment = k == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, k);
            int result = CRYPTO_SECRETBOX_EASY_HANDLE.invokeExact(cSegment, mSegment, nSegment, kSegment);
            if (c != null) {
                MemorySegment.copy(cSegment, 0L, MemorySegment.ofArray(c), 0L, c.length);
            }
            if (m != null) {
                MemorySegment.copy(mSegment, 0L, MemorySegment.ofArray(m), 0L, m.length);
            }
            if (n != null) {
                MemorySegment.copy(nSegment, 0L, MemorySegment.ofArray(n), 0L, n.length);
            }
            if (k != null) {
                MemorySegment.copy(kSegment, 0L, MemorySegment.ofArray(k), 0L, k.length);
            }
            int n2 = result;
            if (arena != null) {
                arena.close();
            }
            return n2;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 crypto_secretbox_easy", e);
            }
        }
    }

    public static int crypto_secretbox_open_easy(byte[] m, byte[] c, byte[] n, byte[] k) {
        if (m == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'm' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (c == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'c' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (n == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'n' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (n != null && n.length != 24) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'n' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_secretbox_NONCEBYTES.");
        }
        if (k == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'k' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (k != null && k.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'k' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_secretbox_KEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment mSegment = m == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, m);
            MemorySegment cSegment = c == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, c);
            MemorySegment nSegment = n == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, n);
            MemorySegment kSegment = k == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, k);
            int result = CRYPTO_SECRETBOX_OPEN_EASY_HANDLE.invokeExact(mSegment, cSegment, nSegment, kSegment);
            if (m != null) {
                MemorySegment.copy(mSegment, 0L, MemorySegment.ofArray(m), 0L, m.length);
            }
            if (c != null) {
                MemorySegment.copy(cSegment, 0L, MemorySegment.ofArray(c), 0L, c.length);
            }
            if (n != null) {
                MemorySegment.copy(nSegment, 0L, MemorySegment.ofArray(n), 0L, n.length);
            }
            if (k != null) {
                MemorySegment.copy(kSegment, 0L, MemorySegment.ofArray(k), 0L, k.length);
            }
            int n2 = result;
            if (arena != null) {
                arena.close();
            }
            return n2;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 crypto_secretbox_open_easy", e);
            }
        }
    }

    public static int crypto_sign_keypair(crypto_sign_keypair keypair) {
        if (keypair == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'keypair' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment keypairSegment;
            MemorySegment memorySegment = keypairSegment = keypair == null ? MemorySegment.NULL : arena.allocate(crypto_sign_keypair.getStaticSize());
            if (keypair != null) {
                keypair.serialize(keypairSegment, 0L, arena);
            }
            int result = CRYPTO_SIGN_KEYPAIR_HANDLE.invokeExact(keypairSegment);
            if (keypair != null) {
                keypair.deserialize(keypairSegment, 0L);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 crypto_sign_keypair", e);
            }
        }
    }

    public static int crypto_sign(byte[] sm, byte[] m, byte[] sk) {
        if (sm == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'sm' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (m == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'm' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (sk == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'sk' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (sk != null && sk.length != 64) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'sk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_sign_SECRETKEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment smSegment = sm == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, sm);
            MemorySegment mSegment = m == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, m);
            MemorySegment skSegment = sk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, sk);
            int result = CRYPTO_SIGN_HANDLE.invokeExact(smSegment, mSegment, skSegment);
            if (sm != null) {
                MemorySegment.copy(smSegment, 0L, MemorySegment.ofArray(sm), 0L, sm.length);
            }
            if (m != null) {
                MemorySegment.copy(mSegment, 0L, MemorySegment.ofArray(m), 0L, m.length);
            }
            if (sk != null) {
                MemorySegment.copy(skSegment, 0L, MemorySegment.ofArray(sk), 0L, sk.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 crypto_sign", e);
            }
        }
    }

    public static int crypto_sign_open(byte[] m, byte[] sm, byte[] pk) {
        if (m == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'm' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (sm == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'sm' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (pk == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'pk' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (pk != null && pk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'pk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_sign_PUBLICKEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment mSegment = m == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, m);
            MemorySegment smSegment = sm == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, sm);
            MemorySegment pkSegment = pk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, pk);
            int result = CRYPTO_SIGN_OPEN_HANDLE.invokeExact(mSegment, smSegment, pkSegment);
            if (m != null) {
                MemorySegment.copy(mSegment, 0L, MemorySegment.ofArray(m), 0L, m.length);
            }
            if (sm != null) {
                MemorySegment.copy(smSegment, 0L, MemorySegment.ofArray(sm), 0L, sm.length);
            }
            if (pk != null) {
                MemorySegment.copy(pkSegment, 0L, MemorySegment.ofArray(pk), 0L, pk.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 crypto_sign_open", e);
            }
        }
    }

    public static int crypto_sign_detached(byte[] sig, byte[] m, byte[] sk) {
        if (sig == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'sig' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (sig != null && sig.length != 64) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'sig' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_sign_BYTES.");
        }
        if (m == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'm' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (sk == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'sk' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (sk != null && sk.length != 64) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'sk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_sign_SECRETKEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment sigSegment = sig == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, sig);
            MemorySegment mSegment = m == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, m);
            MemorySegment skSegment = sk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, sk);
            int result = CRYPTO_SIGN_DETACHED_HANDLE.invokeExact(sigSegment, mSegment, skSegment);
            if (sig != null) {
                MemorySegment.copy(sigSegment, 0L, MemorySegment.ofArray(sig), 0L, sig.length);
            }
            if (m != null) {
                MemorySegment.copy(mSegment, 0L, MemorySegment.ofArray(m), 0L, m.length);
            }
            if (sk != null) {
                MemorySegment.copy(skSegment, 0L, MemorySegment.ofArray(sk), 0L, sk.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 crypto_sign_detached", e);
            }
        }
    }

    public static int crypto_sign_verify_detached(byte[] sig, byte[] m, byte[] pk) {
        if (sig == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'sig' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (sig != null && sig.length != 64) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'sig' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_sign_BYTES.");
        }
        if (m == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'm' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (pk == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'pk' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (pk != null && pk.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'pk' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_sign_PUBLICKEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment sigSegment = sig == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, sig);
            MemorySegment mSegment = m == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, m);
            MemorySegment pkSegment = pk == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, pk);
            int result = CRYPTO_SIGN_VERIFY_DETACHED_HANDLE.invokeExact(sigSegment, mSegment, pkSegment);
            if (sig != null) {
                MemorySegment.copy(sigSegment, 0L, MemorySegment.ofArray(sig), 0L, sig.length);
            }
            if (m != null) {
                MemorySegment.copy(mSegment, 0L, MemorySegment.ofArray(m), 0L, m.length);
            }
            if (pk != null) {
                MemorySegment.copy(pkSegment, 0L, MemorySegment.ofArray(pk), 0L, pk.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 crypto_sign_verify_detached", e);
            }
        }
    }

    public static int crypto_generichash(byte[] out, byte[] in, byte[] key) {
        if (out == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'out' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (in == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'in' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment outSegment = out == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, out);
            MemorySegment inSegment = in == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, in);
            MemorySegment keySegment = key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, key);
            int result = CRYPTO_GENERICHASH_HANDLE.invokeExact(outSegment, inSegment, keySegment);
            if (out != null) {
                MemorySegment.copy(outSegment, 0L, MemorySegment.ofArray(out), 0L, out.length);
            }
            if (in != null) {
                MemorySegment.copy(inSegment, 0L, MemorySegment.ofArray(in), 0L, in.length);
            }
            if (key != null) {
                MemorySegment.copy(keySegment, 0L, MemorySegment.ofArray(key), 0L, key.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 crypto_generichash", e);
            }
        }
    }

    public static int crypto_generichash_init(crypto_generichash_state state, byte[] key, long keylen) {
        if (state == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'state' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment stateSegment;
            MemorySegment memorySegment = stateSegment = state == null ? MemorySegment.NULL : arena.allocate(crypto_generichash_state.getStaticSize());
            if (state != null) {
                state.serialize(stateSegment, 0L, arena);
            }
            MemorySegment keySegment = key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, key);
            int result = CRYPTO_GENERICHASH_INIT_HANDLE.invokeExact(stateSegment, keySegment, keylen);
            if (state != null) {
                state.deserialize(stateSegment, 0L);
            }
            if (key != null) {
                MemorySegment.copy(keySegment, 0L, MemorySegment.ofArray(key), 0L, key.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 crypto_generichash_init", e);
            }
        }
    }

    public static int crypto_generichash_update(crypto_generichash_state state, byte[] in, long inlen) {
        if (state == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'state' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (in == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'in' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment stateSegment;
            MemorySegment memorySegment = stateSegment = state == null ? MemorySegment.NULL : arena.allocate(crypto_generichash_state.getStaticSize());
            if (state != null) {
                state.serialize(stateSegment, 0L, arena);
            }
            MemorySegment inSegment = in == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, in);
            int result = CRYPTO_GENERICHASH_UPDATE_HANDLE.invokeExact(stateSegment, inSegment, inlen);
            if (state != null) {
                state.deserialize(stateSegment, 0L);
            }
            if (in != null) {
                MemorySegment.copy(inSegment, 0L, MemorySegment.ofArray(in), 0L, in.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 crypto_generichash_update", e);
            }
        }
    }

    public static int crypto_generichash_final(crypto_generichash_state state, byte[] out, long outlen) {
        if (state == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'state' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (out == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'out' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment stateSegment;
            MemorySegment memorySegment = stateSegment = state == null ? MemorySegment.NULL : arena.allocate(crypto_generichash_state.getStaticSize());
            if (state != null) {
                state.serialize(stateSegment, 0L, arena);
            }
            MemorySegment outSegment = out == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, out);
            int result = CRYPTO_GENERICHASH_FINAL_HANDLE.invokeExact(stateSegment, outSegment, outlen);
            if (state != null) {
                state.deserialize(stateSegment, 0L);
            }
            if (out != null) {
                MemorySegment.copy(outSegment, 0L, MemorySegment.ofArray(out), 0L, out.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 crypto_generichash_final", e);
            }
        }
    }

    public static int crypto_auth_keygen(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (key != null && key.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'key' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_auth_KEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment keySegment = key == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, key);
            int result = CRYPTO_AUTH_KEYGEN_HANDLE.invokeExact(keySegment);
            if (key != null) {
                MemorySegment.copy(keySegment, 0L, MemorySegment.ofArray(key), 0L, key.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 crypto_auth_keygen", e);
            }
        }
    }

    public static int crypto_auth(byte[] out, byte[] in, byte[] k) {
        if (out == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'out' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (out != null && out.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'out' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_auth_BYTES.");
        }
        if (in == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'in' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (k == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'k' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (k != null && k.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'k' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_auth_KEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment outSegment = out == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, out);
            MemorySegment inSegment = in == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, in);
            MemorySegment kSegment = k == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, k);
            int result = CRYPTO_AUTH_HANDLE.invokeExact(outSegment, inSegment, kSegment);
            if (out != null) {
                MemorySegment.copy(outSegment, 0L, MemorySegment.ofArray(out), 0L, out.length);
            }
            if (in != null) {
                MemorySegment.copy(inSegment, 0L, MemorySegment.ofArray(in), 0L, in.length);
            }
            if (k != null) {
                MemorySegment.copy(kSegment, 0L, MemorySegment.ofArray(k), 0L, k.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 crypto_auth", e);
            }
        }
    }

    public static int crypto_auth_verify(byte[] h, byte[] in, byte[] k) {
        if (h == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'h' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (h != null && h.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'h' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_auth_BYTES.");
        }
        if (in == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'in' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (k == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'k' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (k != null && k.length != 32) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'k' \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 crypto_auth_KEYBYTES.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment hSegment = h == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, h);
            MemorySegment inSegment = in == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, in);
            MemorySegment kSegment = k == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, k);
            int result = CRYPTO_AUTH_VERIFY_HANDLE.invokeExact(hSegment, inSegment, kSegment);
            if (h != null) {
                MemorySegment.copy(hSegment, 0L, MemorySegment.ofArray(h), 0L, h.length);
            }
            if (in != null) {
                MemorySegment.copy(inSegment, 0L, MemorySegment.ofArray(in), 0L, in.length);
            }
            if (k != null) {
                MemorySegment.copy(kSegment, 0L, MemorySegment.ofArray(k), 0L, k.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 crypto_auth_verify", e);
            }
        }
    }

    public static byte[] sodium_bin2hex(byte[] hex, byte[] bin) {
        if (hex == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'hex' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (bin == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'bin' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment hexSegment = hex == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, hex);
            MemorySegment binSegment = bin == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, bin);
            byte[] result = SODIUM_BIN2HEX_HANDLE.invokeExact(hexSegment, binSegment);
            if (hex != null) {
                MemorySegment.copy(hexSegment, 0L, MemorySegment.ofArray(hex), 0L, hex.length);
            }
            if (bin != null) {
                MemorySegment.copy(binSegment, 0L, MemorySegment.ofArray(bin), 0L, bin.length);
            }
            byte[] byArray = result;
            if (arena != null) {
                arena.close();
            }
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 sodium_bin2hex", e);
            }
        }
    }

    public static int sodium_hex2bin(byte[] bin, byte[] hex, long hex_len, String ignore, long[] bin_len, String ignore2) {
        if (bin == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'bin' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (hex == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'hex' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ignore == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ignore' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (bin_len == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'bin_len' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        if (ignore2 == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'ignore2' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null.");
        }
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment ignore2Segment;
            MemorySegment binlenSegment;
            MemorySegment ignoreSegment;
            MemorySegment hexSegment;
            MemorySegment binSegment = bin == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, bin);
            MemorySegment memorySegment = hexSegment = hex == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_BYTE, hex);
            if (ignore == null) {
                ignoreSegment = MemorySegment.NULL;
            } else {
                byte[] ignoreBytes = ignore.getBytes(StandardCharsets.UTF_8);
                ignoreSegment = arena.allocate(ignoreBytes.length + 1);
                ignoreSegment.copyFrom(MemorySegment.ofArray(ignoreBytes));
                ignoreSegment.set(ValueLayout.JAVA_BYTE, (long)ignoreBytes.length, (byte)0);
            }
            MemorySegment memorySegment2 = binlenSegment = bin_len == null ? MemorySegment.NULL : arena.allocateFrom(ValueLayout.JAVA_LONG, bin_len);
            if (ignore2 == null) {
                ignore2Segment = MemorySegment.NULL;
            } else {
                byte[] ignore2Bytes = ignore2.getBytes(StandardCharsets.UTF_8);
                ignore2Segment = arena.allocate(ignore2Bytes.length + 1);
                ignore2Segment.copyFrom(MemorySegment.ofArray(ignore2Bytes));
                ignore2Segment.set(ValueLayout.JAVA_BYTE, (long)ignore2Bytes.length, (byte)0);
            }
            int result = SODIUM_HEX2BIN_HANDLE.invokeExact(binSegment, hexSegment, hex_len, ignoreSegment, binlenSegment, ignore2Segment);
            if (bin != null) {
                MemorySegment.copy(binSegment, 0L, MemorySegment.ofArray(bin), 0L, bin.length);
            }
            if (hex != null) {
                MemorySegment.copy(hexSegment, 0L, MemorySegment.ofArray(hex), 0L, hex.length);
            }
            if (bin_len != null) {
                MemorySegment.copy(binlenSegment, 0L, MemorySegment.ofArray(bin_len), 0L, bin_len.length);
            }
            int n = result;
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u043d\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043c\u0435\u0442\u043e\u0434\u0430 sodium_hex2bin", e);
            }
        }
    }

    static {
        LINKER = Linker.nativeLinker();
        RU.loadLibrary((String)"sodium");
        SYMBOL_LOOKUP = SymbolLookup.loaderLookup();
        CRYPTO_BOX_KEYPAIR_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("crypto_box_keypair").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 crypto_box_keypair \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS), new Linker.Option[0]);
        CRYPTO_BOX_EASY_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("crypto_box_easy").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 crypto_box_easy \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        CRYPTO_BOX_OPEN_EASY_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("crypto_box_open_easy").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 crypto_box_open_easy \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        CRYPTO_SECRETBOX_KEYGEN_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("crypto_secretbox_keygen").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 crypto_secretbox_keygen \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS), new Linker.Option[0]);
        CRYPTO_SECRETBOX_EASY_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("crypto_secretbox_easy").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 crypto_secretbox_easy \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        CRYPTO_SECRETBOX_OPEN_EASY_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("crypto_secretbox_open_easy").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 crypto_secretbox_open_easy \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        CRYPTO_SIGN_KEYPAIR_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("crypto_sign_keypair").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 crypto_sign_keypair \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS), new Linker.Option[0]);
        CRYPTO_SIGN_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("crypto_sign").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 crypto_sign \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        CRYPTO_SIGN_OPEN_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("crypto_sign_open").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 crypto_sign_open \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        CRYPTO_SIGN_DETACHED_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("crypto_sign_detached").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 crypto_sign_detached \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        CRYPTO_SIGN_VERIFY_DETACHED_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("crypto_sign_verify_detached").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 crypto_sign_verify_detached \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        CRYPTO_GENERICHASH_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("crypto_generichash").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 crypto_generichash \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        CRYPTO_GENERICHASH_INIT_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("crypto_generichash_init").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 crypto_generichash_init \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG), new Linker.Option[0]);
        CRYPTO_GENERICHASH_UPDATE_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("crypto_generichash_update").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 crypto_generichash_update \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG), new Linker.Option[0]);
        CRYPTO_GENERICHASH_FINAL_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("crypto_generichash_final").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 crypto_generichash_final \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG), new Linker.Option[0]);
        CRYPTO_AUTH_KEYGEN_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("crypto_auth_keygen").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 crypto_auth_keygen \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS), new Linker.Option[0]);
        CRYPTO_AUTH_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("crypto_auth").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 crypto_auth \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        CRYPTO_AUTH_VERIFY_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("crypto_auth_verify").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 crypto_auth_verify \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        SODIUM_BIN2HEX_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("sodium_bin2hex").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 sodium_bin2hex \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
        SODIUM_HEX2BIN_HANDLE = LINKER.downcallHandle(SYMBOL_LOOKUP.find("sodium_hex2bin").orElseThrow(() -> new UnsatisfiedLinkError("\u041c\u0435\u0442\u043e\u0434 sodium_hex2bin \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]);
    }

    public static class crypto_box_keypair {
        public byte[] pk;
        public byte[] sk;

        public crypto_box_keypair() {
            this.pk = new byte[32];
            this.sk = new byte[32];
        }

        public crypto_box_keypair(byte[] pk, byte[] sk) {
            this.pk = pk;
            this.sk = sk;
        }

        public byte[] getPk() {
            return this.pk;
        }

        public byte[] getSk() {
            return this.sk;
        }

        public long serialize(MemorySegment segment, long offset, Arena arena) {
            long currentOffset = offset;
            MemorySegment.copy(MemorySegment.ofArray(this.pk), 0L, segment, currentOffset, this.pk.length);
            MemorySegment.copy(MemorySegment.ofArray(this.sk), 0L, segment, currentOffset += (long)(1 * this.pk.length), this.sk.length);
            return currentOffset += (long)(1 * this.sk.length);
        }

        public void deserialize(MemorySegment segment, long offset) {
            long currentOffset = offset;
            MemorySegment.copy(segment, currentOffset, MemorySegment.ofArray(this.pk), 0L, this.pk.length);
            MemorySegment.copy(segment, currentOffset += (long)(1 * this.pk.length), MemorySegment.ofArray(this.sk), 0L, this.sk.length);
            currentOffset += (long)(1 * this.sk.length);
        }

        public int getSerializedSize() {
            return 64;
        }

        public static int getStaticSize() {
            return 64;
        }
    }

    public static class crypto_sign_keypair {
        public byte[] pk;
        public byte[] sk;

        public crypto_sign_keypair() {
            this.pk = new byte[32];
            this.sk = new byte[64];
        }

        public crypto_sign_keypair(byte[] pk, byte[] sk) {
            this.pk = pk;
            this.sk = sk;
        }

        public byte[] getPk() {
            return this.pk;
        }

        public byte[] getSk() {
            return this.sk;
        }

        public long serialize(MemorySegment segment, long offset, Arena arena) {
            long currentOffset = offset;
            MemorySegment.copy(MemorySegment.ofArray(this.pk), 0L, segment, currentOffset, this.pk.length);
            MemorySegment.copy(MemorySegment.ofArray(this.sk), 0L, segment, currentOffset += (long)(1 * this.pk.length), this.sk.length);
            return currentOffset += (long)(1 * this.sk.length);
        }

        public void deserialize(MemorySegment segment, long offset) {
            long currentOffset = offset;
            MemorySegment.copy(segment, currentOffset, MemorySegment.ofArray(this.pk), 0L, this.pk.length);
            MemorySegment.copy(segment, currentOffset += (long)(1 * this.pk.length), MemorySegment.ofArray(this.sk), 0L, this.sk.length);
            currentOffset += (long)(1 * this.sk.length);
        }

        public int getSerializedSize() {
            return 96;
        }

        public static int getStaticSize() {
            return 96;
        }
    }

    public static class crypto_generichash_state {
        public long[] h;
        public byte[] buf;
        public long buflen;
        public long buflen_max;
        public long[] pad;

        public crypto_generichash_state() {
            this.h = new long[8];
            this.buf = new byte[64];
            this.pad = new long[2];
        }

        public crypto_generichash_state(long[] h, byte[] buf, long buflen, long buflen_max, long[] pad) {
            this.h = h;
            this.buf = buf;
            this.buflen = buflen;
            this.buflen_max = buflen_max;
            this.pad = pad;
        }

        public long[] getH() {
            return this.h;
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public long getBuflen() {
            return this.buflen;
        }

        public long getBuflen_max() {
            return this.buflen_max;
        }

        public long[] getPad() {
            return this.pad;
        }

        public long serialize(MemorySegment segment, long offset, Arena arena) {
            int i;
            long currentOffset = offset;
            for (i = 0; i < this.h.length; ++i) {
                segment.set(ValueLayout.JAVA_LONG, currentOffset + (long)(i * 8), this.h[i]);
            }
            MemorySegment.copy(MemorySegment.ofArray(this.buf), 0L, segment, currentOffset += (long)(8 * this.h.length), this.buf.length);
            segment.set(ValueLayout.JAVA_LONG, currentOffset += (long)(1 * this.buf.length), this.buflen);
            segment.set(ValueLayout.JAVA_LONG, currentOffset += 8L, this.buflen_max);
            currentOffset += 8L;
            for (i = 0; i < this.pad.length; ++i) {
                segment.set(ValueLayout.JAVA_LONG, currentOffset + (long)(i * 8), this.pad[i]);
            }
            return currentOffset += (long)(8 * this.pad.length);
        }

        public void deserialize(MemorySegment segment, long offset) {
            int i;
            long currentOffset = offset;
            for (i = 0; i < this.h.length; ++i) {
                this.h[i] = segment.get(ValueLayout.JAVA_LONG, currentOffset + (long)(i * 8));
            }
            MemorySegment.copy(segment, currentOffset += (long)(8 * this.h.length), MemorySegment.ofArray(this.buf), 0L, this.buf.length);
            this.buflen = segment.get(ValueLayout.JAVA_LONG, currentOffset += (long)(1 * this.buf.length));
            this.buflen_max = segment.get(ValueLayout.JAVA_LONG, currentOffset += 8L);
            currentOffset += 8L;
            for (i = 0; i < this.pad.length; ++i) {
                this.pad[i] = segment.get(ValueLayout.JAVA_LONG, currentOffset + (long)(i * 8));
            }
            currentOffset += (long)(8 * this.pad.length);
        }

        public int getSerializedSize() {
            return 160;
        }

        public static int getStaticSize() {
            return 160;
        }
    }

    public static class crypto_auth_state {
        public long[] h;
        public byte[] buf;
        public long buflen;
        public long buflen_max;
        public long[] pad;
        public byte[] k;

        public crypto_auth_state() {
            this.h = new long[8];
            this.buf = new byte[64];
            this.pad = new long[2];
            this.k = new byte[32];
        }

        public crypto_auth_state(long[] h, byte[] buf, long buflen, long buflen_max, long[] pad, byte[] k) {
            this.h = h;
            this.buf = buf;
            this.buflen = buflen;
            this.buflen_max = buflen_max;
            this.pad = pad;
            this.k = k;
        }

        public long[] getH() {
            return this.h;
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public long getBuflen() {
            return this.buflen;
        }

        public long getBuflen_max() {
            return this.buflen_max;
        }

        public long[] getPad() {
            return this.pad;
        }

        public byte[] getK() {
            return this.k;
        }

        public long serialize(MemorySegment segment, long offset, Arena arena) {
            int i;
            long currentOffset = offset;
            for (i = 0; i < this.h.length; ++i) {
                segment.set(ValueLayout.JAVA_LONG, currentOffset + (long)(i * 8), this.h[i]);
            }
            MemorySegment.copy(MemorySegment.ofArray(this.buf), 0L, segment, currentOffset += (long)(8 * this.h.length), this.buf.length);
            segment.set(ValueLayout.JAVA_LONG, currentOffset += (long)(1 * this.buf.length), this.buflen);
            segment.set(ValueLayout.JAVA_LONG, currentOffset += 8L, this.buflen_max);
            currentOffset += 8L;
            for (i = 0; i < this.pad.length; ++i) {
                segment.set(ValueLayout.JAVA_LONG, currentOffset + (long)(i * 8), this.pad[i]);
            }
            MemorySegment.copy(MemorySegment.ofArray(this.k), 0L, segment, currentOffset += (long)(8 * this.pad.length), this.k.length);
            return currentOffset += (long)(1 * this.k.length);
        }

        public void deserialize(MemorySegment segment, long offset) {
            int i;
            long currentOffset = offset;
            for (i = 0; i < this.h.length; ++i) {
                this.h[i] = segment.get(ValueLayout.JAVA_LONG, currentOffset + (long)(i * 8));
            }
            MemorySegment.copy(segment, currentOffset += (long)(8 * this.h.length), MemorySegment.ofArray(this.buf), 0L, this.buf.length);
            this.buflen = segment.get(ValueLayout.JAVA_LONG, currentOffset += (long)(1 * this.buf.length));
            this.buflen_max = segment.get(ValueLayout.JAVA_LONG, currentOffset += 8L);
            currentOffset += 8L;
            for (i = 0; i < this.pad.length; ++i) {
                this.pad[i] = segment.get(ValueLayout.JAVA_LONG, currentOffset + (long)(i * 8));
            }
            MemorySegment.copy(segment, currentOffset += (long)(8 * this.pad.length), MemorySegment.ofArray(this.k), 0L, this.k.length);
            currentOffset += (long)(1 * this.k.length);
        }

        public int getSerializedSize() {
            return 192;
        }

        public static int getStaticSize() {
            return 192;
        }
    }
}

