package io.aether.crypto.sodium;

import com.goterl.lazysodium.interfaces.Sign;
import com.goterl.lazysodium.utils.Key;

public interface KeySize {
    int SODIUM_CURVE25519_PUBLIC = 32;
    int SODIUM_CURVE_PRIVATE = 32;
    int SODIUM_CURVE_MACBYTES = 16;
    int SODIUM_CURVE_SEALBYTES = SODIUM_CURVE25519_PUBLIC + SODIUM_CURVE_MACBYTES;

    int SODIUM_CHACHA20POLY1305 = 32;
    int SODIUM_CHACHA20POLY1305_ABYTES = 16;
    int SODIUM_CHACHA20POLY1305_NONCE_LEN = 8;

    int SODIUM_SIGN_PUBLIC = Sign.PUBLICKEYBYTES;
    int SODIUM_SIGN_PRIVATE = Sign.SECRETKEYBYTES;
    int SODIUM_SIGN_BYTES = Sign.BYTES;
}

