/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto.sodium;

import com.goterl.lazysodium.LazySodiumJava;
import com.goterl.lazysodium.SodiumJava;
import com.goterl.lazysodium.exceptions.SodiumException;
import com.goterl.lazysodium.utils.KeyPair;
import io.aether.crypto.AKey;
import io.aether.crypto.CryptoEngine;
import io.aether.crypto.CryptoProvider;
import io.aether.crypto.EncryptException;
import io.aether.crypto.KeyType;
import io.aether.crypto.PairAsymKeys;
import io.aether.crypto.PairSignKeys;
import io.aether.crypto.PairSymKeys;
import io.aether.crypto.Sign;
import io.aether.crypto.Signer;
import io.aether.crypto.sodium.SodiumAsymmetricEngine;
import io.aether.crypto.sodium.SodiumKey;
import io.aether.crypto.sodium.SodiumSign;
import io.aether.crypto.sodium.SodiumSigner;
import io.aether.crypto.sodium.SodiumSymmetricEngine;
import io.aether.utils.HexUtils;
import io.aether.utils.RU;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class SodiumCryptoProvider
implements CryptoProvider {
    public static final SodiumCryptoProvider INSTANCE = new SodiumCryptoProvider();
    private final LazySodiumJava lazySodium;
    private final SodiumJava sodium = new SodiumJava();
    private static final byte[] SODIUM_KDF_CONTEXT = "_aether_".getBytes(StandardCharsets.UTF_8);

    public AKey.SignPublic createSignPublicKey(byte[] data) {
        return new SodiumKey.SignPublic(data);
    }

    public AKey.SignPrivate createSignPrivateKey(byte[] data) {
        return new SodiumKey.SignPrivate(data);
    }

    public AKey.Symmetric createSymmetricKey(byte[] bytes) {
        return new SodiumKey.Symmetric(bytes);
    }

    private SodiumCryptoProvider() {
        this.lazySodium = new LazySodiumJava(this.sodium);
    }

    public String getCryptoLibName() {
        return "SODIUM";
    }

    public PairAsymKeys createAsymmetricKeys() {
        byte[] privateKey = new byte[32];
        byte[] publicKey = new byte[32];
        this.sodium.crypto_box_keypair(publicKey, privateKey);
        return new PairAsymKeys((AKey.AsymmetricPublic)new SodiumKey.AsymmetricPublic(publicKey), (AKey.AsymmetricPrivate)new SodiumKey.AsymmetricPrivate(privateKey));
    }

    public AKey.Symmetric createSymmetricKey() {
        byte[] key = new byte[32];
        this.sodium.crypto_aead_chacha20poly1305_keygen(key);
        return new SodiumKey.Symmetric(key);
    }

    public PairSignKeys createSignKeys() {
        try {
            KeyPair keys = this.lazySodium.cryptoSignKeypair();
            byte[] publicKey = keys.getPublicKey().getAsBytes();
            byte[] privateKey = keys.getSecretKey().getAsBytes();
            return new PairSignKeys((AKey.SignPublic)new SodiumKey.SignPublic(publicKey), (AKey.SignPrivate)new SodiumKey.SignPrivate(privateKey));
        }
        catch (SodiumException e) {
            throw new EncryptException("Failed to generate signing keys", (Throwable)e);
        }
    }

    public Signer createSigner(PairSignKeys keys) {
        return this.createSigner(keys.publicKey, keys.privateKey);
    }

    public Signer createSigner(AKey.SignPublic publicKey, AKey.SignPrivate privateKey) {
        if (!(publicKey instanceof SodiumKey.SignPublic) || !(privateKey instanceof SodiumKey.SignPrivate)) {
            throw new IllegalArgumentException("Keys must be instances of SodiumKey.SignPublic and SodiumKey.SignPrivate");
        }
        return new SodiumSigner(publicKey, privateKey, this.lazySodium);
    }

    public Signer createSigner(AKey.SignPublic publicKey) {
        if (!(publicKey instanceof SodiumKey.SignPublic)) {
            throw new IllegalArgumentException("Public key must be an instance of SodiumKey.SignPublic");
        }
        return new SodiumSigner(publicKey, null, this.lazySodium);
    }

    public CryptoEngine createSymmetricEngine(AKey.Symmetric key) {
        if (!(key instanceof SodiumKey.Symmetric)) {
            throw new IllegalArgumentException("Key must be a SodiumKey.Symmetric instance");
        }
        return new SodiumSymmetricEngine(key);
    }

    public CryptoEngine createAsymmetricEngine(AKey.AsymmetricPublic key) {
        if (!(key instanceof SodiumKey.AsymmetricPublic)) {
            throw new IllegalArgumentException("Key must be a SodiumKey.AsymmetricPublic instance");
        }
        return new SodiumAsymmetricEngine(key);
    }

    public CryptoEngine createAsymmetricEngine(AKey.AsymmetricPrivate privateKey, AKey.AsymmetricPublic publicKey) {
        if (!(privateKey instanceof SodiumKey.AsymmetricPrivate) || !(publicKey instanceof SodiumKey.AsymmetricPublic)) {
            throw new IllegalArgumentException("Keys must be instances of SodiumKey.AsymmetricPrivate and SodiumKey.AsymmetricPublic");
        }
        return new SodiumAsymmetricEngine(privateKey, publicKey);
    }

    public CryptoEngine createAsymmetricEngine(PairAsymKeys keys) {
        return this.createAsymmetricEngine(keys.getPrivateKey(), keys.getPublicKey());
    }

    public <T extends AKey> T createKey(KeyType keyType, byte[] data) {
        SodiumKey result;
        switch (keyType) {
            case SYMMETRIC: {
                result = new SodiumKey.Symmetric(data);
                break;
            }
            case ASYMMETRIC_PUBLIC: {
                result = new SodiumKey.AsymmetricPublic(data);
                break;
            }
            case ASYMMETRIC_PRIVATE: {
                result = new SodiumKey.AsymmetricPrivate(data);
                break;
            }
            case SIGN_PUBLIC: {
                result = new SodiumKey.SignPublic(data);
                break;
            }
            case SIGN_PRIVATE: {
                result = new SodiumKey.SignPrivate(data);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return (T)((AKey)RU.cast((Object)result));
    }

    public <T extends AKey> T createKey(String data) {
        String[] parts = data.split(":");
        if (parts.length != 3 || !parts[0].equals(this.getCryptoLibName())) {
            throw new IllegalArgumentException("Invalid key string for this provider.");
        }
        KeyType keyType = KeyType.valueOf((String)parts[1]);
        byte[] bytes = HexUtils.hexToBytes((CharSequence)parts[2]);
        return (T)((AKey)RU.cast(this.createKey(keyType, bytes)));
    }

    public Sign createSign(String data) {
        String[] parts = data.split(":");
        if (parts.length != 2 || !parts[0].equals(this.getCryptoLibName())) {
            throw new IllegalArgumentException("Invalid sign string for this provider.");
        }
        return new SodiumSign(HexUtils.hexToBytes((CharSequence)parts[1]));
    }

    public PairSymKeys deriveSymmetricKeys(AKey.Symmetric masterKey, int serverId, int keyNumber) {
        if (!(masterKey instanceof SodiumKey.Symmetric)) {
            throw new IllegalArgumentException("Key must be a SodiumKey.Symmetric instance");
        }
        int keySize = 32;
        byte[] derivedKey = new byte[keySize * 2];
        long subkeyId = (long)serverId << 32 | (long)keyNumber & 0xFFFFFFFFL;
        int result = this.sodium.crypto_kdf_derive_from_key(derivedKey, derivedKey.length, subkeyId, SODIUM_KDF_CONTEXT, masterKey.getData());
        if (result != 0) {
            throw new RuntimeException("Sodium KDF derivation failed with error code: " + result);
        }
        byte[] clientToServerKeyBytes = Arrays.copyOfRange(derivedKey, 0, keySize);
        byte[] serverToClientKeyBytes = Arrays.copyOfRange(derivedKey, keySize, derivedKey.length);
        SodiumKey.Symmetric clientToServerKey = new SodiumKey.Symmetric(clientToServerKeyBytes);
        SodiumKey.Symmetric serverToClientKey = new SodiumKey.Symmetric(serverToClientKeyBytes);
        return new PairSymKeys((AKey.Symmetric)clientToServerKey, (AKey.Symmetric)serverToClientKey);
    }

    public Sign createSign(byte[] data) {
        return new SodiumSign(data);
    }
}

