/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto.sodium;

import io.aether.crypto.AKey;
import io.aether.crypto.CryptoEngine;
import io.aether.crypto.CryptoProvider;
import io.aether.crypto.CryptoProviderFactory;
import io.aether.crypto.KeyType;
import io.aether.crypto.SignChecker;
import io.aether.crypto.sodium.SodiumCryptoProvider;
import io.aether.utils.HexUtils;
import java.util.Arrays;
import java.util.Objects;

public abstract class SodiumKey
implements AKey {
    protected final byte[] data;
    protected final KeyType keyType;
    protected final String providerName = "SODIUM";

    protected SodiumKey(byte[] data, KeyType keyType) {
        this.data = data;
        this.keyType = keyType;
    }

    public byte[] getData() {
        return this.data;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public String getProviderName() {
        return "SODIUM";
    }

    public CryptoProvider getCryptoProvider() {
        return SodiumCryptoProvider.INSTANCE;
    }

    public int size() {
        return this.data.length;
    }

    public String keyToString() {
        return this.getProviderName() + ":" + String.valueOf(this.getKeyType()) + ":" + HexUtils.toHexString((byte[])this.getData());
    }

    public String toString() {
        return this.keyToString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AKey) {
            AKey k = (AKey)obj;
            return this.getKeyType() == k.getKeyType() && this.getProviderName().equals(k.getProviderName()) && Arrays.equals(this.getData(), k.getData());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getKeyType(), this.getProviderName(), Arrays.hashCode(this.getData()));
    }

    public static class SignPublic
    extends SodiumKey
    implements AKey.SignPublic {
        public SignPublic(byte[] data) {
            super(data, KeyType.SIGN_PUBLIC);
        }

        public SignChecker toSignChecker() {
            return CryptoProviderFactory.getProvider((AKey)this).createSigner((AKey.SignPublic)this);
        }
    }

    public static class SignPrivate
    extends SodiumKey
    implements AKey.SignPrivate {
        public SignPrivate(byte[] data) {
            super(data, KeyType.SIGN_PRIVATE);
        }
    }

    public static class AsymmetricPublic
    extends SodiumKey
    implements AKey.AsymmetricPublic {
        public AsymmetricPublic(byte[] data) {
            super(data, KeyType.ASYMMETRIC_PUBLIC);
        }

        public CryptoEngine toCryptoEngine() {
            return CryptoProviderFactory.getProvider((AKey)this).createAsymmetricEngine((AKey.AsymmetricPublic)this);
        }
    }

    public static class AsymmetricPrivate
    extends SodiumKey
    implements AKey.AsymmetricPrivate {
        public AsymmetricPrivate(byte[] data) {
            super(data, KeyType.ASYMMETRIC_PRIVATE);
        }
    }

    public static class Symmetric
    extends SodiumKey
    implements AKey.Symmetric {
        public Symmetric(byte[] data) {
            super(data, KeyType.SYMMETRIC);
        }

        public CryptoEngine toCryptoEngine() {
            return CryptoProviderFactory.getProvider((AKey)this).createSymmetricEngine((AKey.Symmetric)this);
        }
    }
}

