/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto.sodium;

import com.goterl.lazysodium.LazySodiumJava;
import io.aether.crypto.AKey;
import io.aether.crypto.CryptoProvider;
import io.aether.crypto.Sign;
import io.aether.crypto.Signer;
import io.aether.crypto.sodium.SodiumCryptoProvider;
import io.aether.crypto.sodium.SodiumSign;

public class SodiumSigner
implements Signer {
    private final AKey.SignPublic publicKey;
    private final AKey.SignPrivate privateKey;
    private final LazySodiumJava lazySodium;

    public SodiumSigner(AKey.SignPublic publicKey, AKey.SignPrivate privateKey, LazySodiumJava lazySodium) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.lazySodium = lazySodium;
    }

    public Sign sign(byte[] data) {
        if (this.privateKey == null) {
            throw new IllegalStateException("This Signer instance is not configured with a private key for signing.");
        }
        byte[] res = new byte[64];
        this.lazySodium.cryptoSignDetached(res, data, (long)data.length, this.privateKey.getData());
        return new SodiumSign(res);
    }

    public boolean checkSign(byte[] data, Sign sign) {
        if (!(sign instanceof SodiumSign)) {
            throw new IllegalArgumentException("Sign must be a SodiumSign instance");
        }
        if (this.publicKey == null) {
            throw new IllegalStateException("This Signer instance is not configured with a public key for checking.");
        }
        return this.lazySodium.cryptoSignVerifyDetached(sign.getSignData(), data, data.length, this.publicKey.getData());
    }

    public AKey.SignPublic getPublicKey() {
        return this.publicKey;
    }

    public String getProviderName() {
        return "SODIUM";
    }

    public CryptoProvider getCryptoProvider() {
        return SodiumCryptoProvider.INSTANCE;
    }
}

