/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto.sodium;

import com.goterl.lazysodium.SodiumJava;
import io.aether.crypto.AKey;
import io.aether.crypto.CryptoEngine;
import io.aether.crypto.CryptoProvider;
import io.aether.crypto.DecryptException;
import io.aether.crypto.EncryptException;
import io.aether.crypto.sodium.Nonce;
import io.aether.crypto.sodium.SodiumCryptoProvider;
import io.aether.utils.DataUtils;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class SodiumSymmetricEngine
implements CryptoEngine {
    private static final SodiumJava SODIUM = new SodiumJava();
    private final AKey.Symmetric key;
    private final Nonce nonce;

    public SodiumSymmetricEngine(AKey.Symmetric key) {
        this.key = key;
        this.nonce = new Nonce();
    }

    public byte @NotNull [] encrypt(byte @NotNull [] data) {
        if (data == null || data.length == 0) {
            return new byte[0];
        }
        int outSize = data.length + 16;
        byte[] output = new byte[outSize + 8];
        long currentNonce = this.nonce.incAndGet();
        byte[] nonceBuf = new byte[8];
        DataUtils.writeLongLE((byte[])nonceBuf, (int)0, (long)currentNonce);
        int res = SODIUM.crypto_aead_chacha20poly1305_encrypt(output, new long[1], data, (long)data.length, null, 0L, null, nonceBuf, this.key.getData());
        if (res != 0) {
            throw new EncryptException("Encrypt exception");
        }
        System.arraycopy(nonceBuf, 0, output, outSize, 8);
        return output;
    }

    public byte @NotNull [] decrypt(byte @NotNull [] data) {
        if (data == null || data.length == 0) {
            return new byte[0];
        }
        int outSize = data.length - 16 - 8;
        byte[] output = new byte[outSize];
        long[] len = new long[1];
        long nonceValue = DataUtils.readLongLE((byte[])data, (int)(data.length - 8));
        byte[] nonceBuf = new byte[8];
        DataUtils.writeLongLE((byte[])nonceBuf, (int)0, (long)nonceValue);
        int res = SODIUM.crypto_aead_chacha20poly1305_decrypt(output, len, null, data, (long)(data.length - 8), null, 0L, nonceBuf, this.key.getData());
        if (res == -1) {
            throw new DecryptException("Decrypt exception");
        }
        if ((long)output.length != len[0]) {
            return Arrays.copyOf(output, (int)len[0]);
        }
        return output;
    }

    public String getProviderName() {
        return "SODIUM";
    }

    public CryptoProvider getCryptoProvider() {
        return SodiumCryptoProvider.INSTANCE;
    }
}

