/*
 * Decompiled with CFR 0.152.
 */
package io.aether.examples.plainChat;

import io.aether.api.chatdsl.MessageDescriptor;
import io.aether.api.chatdsl.ServiceClientApi;
import io.aether.api.chatdsl.ServiceServerApi;
import io.aether.api.chatdsl.ServiceServerApiRemote;
import io.aether.api.chatdsl.UserDescriptor;
import io.aether.cloud.client.AetherCloudClient;
import io.aether.cloud.client.ClientState;
import io.aether.cloud.client.ClientStateInMemory;
import io.aether.logger.Log;
import io.aether.net.fastMeta.FastApiContextLocal;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import io.aether.utils.slots.EventConsumer;
import io.aether.utils.slots.EventConsumerWithQueue;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class ChatClient
implements ServiceClientApi {
    public final AetherCloudClient aether;
    public final EventConsumer<MessageDescriptor> onMessage = new EventConsumerWithQueue();
    private final Map<UUID, UserDescriptor> users = new ConcurrentHashMap<UUID, UserDescriptor>();
    private final ARFuture<ServiceServerApiRemote> service = ARFuture.make();
    private final String name;

    public ChatClient(UUID chatService, List<URI> regUri, String name) {
        this.name = name;
        this.aether = new AetherCloudClient((ClientState)new ClientStateInMemory(chatService, regUri), name);
        ((AFuture)this.aether.startFuture.to(() -> {
            try {
                FastApiContextLocal s = this.aether.getMessageNode(chatService).toApiR(ServiceClientApi.META, c -> {
                    this.service.done((Object)((ServiceServerApiRemote)c.makeRemote(ServiceServerApi.META)));
                    return this;
                });
                this.service.to(a -> a.registration(name).timeout(3, () -> Log.warn((String)"registration timeout: $name", (Object[])new Object[]{"name", name})));
            }
            catch (Exception e) {
                Log.error((Throwable)e, (Object[])new Object[0]);
            }
        })).timeout(3, () -> Log.warn((String)"create aether client timeout: $name", (Object[])new Object[]{"name", name}));
        this.service.timeout(4, () -> Log.warn((String)"get chat service timeout $name", (Object[])new Object[]{"name", name}));
    }

    @Override
    public void addNewUsers(UserDescriptor[] users) {
        for (UserDescriptor u : users) {
            this.users.put(u.getUid(), u);
        }
    }

    public Map<UUID, UserDescriptor> getUsers() {
        return this.users;
    }

    public void sendMessage(String message) {
        this.service.to(s -> s.sendMessage(message)).timeout(5, () -> Log.warn((String)"send chat message timeout for: $name", (Object[])new Object[]{"name", this.name}));
    }

    @Override
    public void newMessages(MessageDescriptor[] messages) {
        for (MessageDescriptor m : messages) {
            this.onMessage.fire((Object)m);
            UserDescriptor u = this.users.get(m.getUid());
            if (u == null) {
                Log.info((String)"new message $msg", (Object[])new Object[]{"msg", m});
                continue;
            }
            Log.info((String)"new message from: $from ($msg)", (Object[])new Object[]{"from", u.getName(), "msg", m.getMessage()});
        }
    }
}

