package io.aether.api.chatdsl;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class MessageDescriptor implements io.aether.utils.ToString  {
    public static final FastMetaType<MessageDescriptor> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_13, MessageDescriptor obj_14, DataOut out_15) {
            FastMeta.META_UUID.serialize(serializeContextVar_13,obj_14.uid,out_15);
            var stringData_17=obj_14.message.getBytes();
            SerializerPackNumber.INSTANCE.put(out_15,stringData_17.length);
            out_15.write(stringData_17);
            
        }
        @Override public MessageDescriptor deserialize(FastFutureContext serializeContextVar_13, DataIn in_16) {
            UUID uid_18;
            String message_19;
            uid_18=FastMeta.META_UUID.deserialize(serializeContextVar_13,in_16);
            byte[] stringData_20;
            var arraySize_21 = DeserializerPackNumber.INSTANCE.put(in_16).intValue();
            stringData_20=new byte[arraySize_21];
            in_16.read(stringData_20);
            message_19=new String(stringData_20);
            return new MessageDescriptor(uid_18,message_19);
            
        }
        
    };
    public static final FastMetaType<MessageDescriptor> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_22, MessageDescriptor obj_23, DataOut out_24) {
            MessageDescriptor.META_BODY.serialize(serializeContextVar_22, obj_23, out_24);
            
        }
        @Override public MessageDescriptor deserialize(FastFutureContext serializeContextVar_22, DataIn in_25) {
            return MessageDescriptor.META_BODY.deserialize(serializeContextVar_22, in_25);
            
        }
        
    };
    protected final UUID uid;
    protected final String message;
    public MessageDescriptor(UUID uid, String message)  {
        this.uid = uid;
        this.message = message;
        
    }
    public UUID getUid()  {
        return this.uid;
        
    }
    public String getMessage()  {
        return this.message;
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof MessageDescriptor)) return false;
        MessageDescriptor that = (MessageDescriptor) o;
        return java.util.Objects.equals(this.uid, that.uid) && java.util.Objects.equals(this.message, that.message);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(this.uid, this.message);
        
    }
    @Override public String toString()  {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("MessageDescriptor(");
        sb.add("uid:");
        sb.add(this.uid);
        sb.add(", ");
        sb.add("message:");
        sb.add(this.message);
        sb.add(')');
        
    }
    
}