package io.aether.api.chatdsl;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public interface ServiceClientApi  {
    FastMetaApi<ServiceClientApi,ServiceClientApiRemote> META=new FastMetaApi<>() {
        public void makeLocal(FastFutureContext serializeContextVar_26, DataIn in_, ServiceClientApi localApi) {
            while(in_.isReadable()) {
                byte commandId = in_.readByte();
                switch(commandId)  {
                    case 0: {
                        var requestId_27 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_26,in_);
                        var futureRec_28 = serializeContextVar_26.getFuture(requestId_27);
                        if(futureRec_28 != null) futureRec_28.onDone(in_);
                        break;
                        
                    }
                    case 1: {
                        var requestId_29 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_26,in_);
                        var futureRec_30 = serializeContextVar_26.getFuture(requestId_29);
                        if(futureRec_30 != null) futureRec_30.onError(in_);
                        break;
                        
                    }
                    case 3:  {
                        UserDescriptor[] users_32;
                        var arraySize_33 = DeserializerPackNumber.INSTANCE.put(in_).intValue();
                        users_32=new UserDescriptor[arraySize_33];
                        for(var forVar_34=0; forVar_34<arraySize_33; forVar_34++) {
                            users_32[forVar_34]=UserDescriptor.META.deserialize(serializeContextVar_26,in_);
                            
                        }
                        String[] argsNames_35 = new String[] {
                            "users"
                        };
                        Object[] argsValues_36 = new Object[] {
                            users_32
                        };
                        serializeContextVar_26.invokeLocalMethodBefore("addNewUsers", argsNames_35, argsValues_36);
                        localApi.addNewUsers(users_32);
                        serializeContextVar_26.invokeLocalMethodAfter("addNewUsers", null, argsNames_35, argsValues_36);
                        break;
                        
                    }
                    case 4:  {
                        MessageDescriptor[] messages_38;
                        var arraySize_39 = DeserializerPackNumber.INSTANCE.put(in_).intValue();
                        messages_38=new MessageDescriptor[arraySize_39];
                        for(var forVar_40=0; forVar_40<arraySize_39; forVar_40++) {
                            messages_38[forVar_40]=MessageDescriptor.META.deserialize(serializeContextVar_26,in_);
                            
                        }
                        String[] argsNames_41 = new String[] {
                            "messages"
                        };
                        Object[] argsValues_42 = new Object[] {
                            messages_38
                        };
                        serializeContextVar_26.invokeLocalMethodBefore("newMessages", argsNames_41, argsValues_42);
                        localApi.newMessages(messages_38);
                        serializeContextVar_26.invokeLocalMethodAfter("newMessages", null, argsNames_41, argsValues_42);
                        break;
                        
                    }
                    default: throw new IllegalArgumentException("Unknown command ID: " + commandId);
                    
                }
                
            }
            
        }
        public ServiceClientApiRemote makeRemote(FastFutureContext localApi_44) {
            return new ServiceClientApiRemote() {
                @Override public void flush(AFuture sendFuture) {
                    localApi_44.flush(sendFuture);
                    
                }
                public io.aether.net.fastMeta.FastFutureContext getFastMetaContext() {
                    return localApi_44;
                    
                }
                @Override public @Command(3) void addNewUsers(UserDescriptor[] users) {
                    var dataOut_45 = new DataInOut();
                    dataOut_45.writeByte(3);
                    String[] argsNames_47 = new String[] {
                        "users"
                    };
                    Object[] argsValues_48 = new Object[] {
                        users
                    };
                    localApi_44.invokeRemoteMethodAfter("addNewUsers", null, argsNames_47, argsValues_48);
                    SerializerPackNumber.INSTANCE.put(dataOut_45,users.length);
                    for(var forVar_49:users) {
                        UserDescriptor.META.serialize(localApi_44,forVar_49,dataOut_45);
                        
                    }
                    localApi_44.sendToRemote(dataOut_45.toArray());
                    
                }
                @Override public @Command(4) void newMessages(MessageDescriptor[] messages) {
                    var dataOut_50 = new DataInOut();
                    dataOut_50.writeByte(4);
                    String[] argsNames_52 = new String[] {
                        "messages"
                    };
                    Object[] argsValues_53 = new Object[] {
                        messages
                    };
                    localApi_44.invokeRemoteMethodAfter("newMessages", null, argsNames_52, argsValues_53);
                    SerializerPackNumber.INSTANCE.put(dataOut_50,messages.length);
                    for(var forVar_54:messages) {
                        MessageDescriptor.META.serialize(localApi_44,forVar_54,dataOut_50);
                        
                    }
                    localApi_44.sendToRemote(dataOut_50.toArray());
                    
                }
                
            };
            
        }
        
    };
    @Command(3) void addNewUsers(UserDescriptor[] users);
    @Command(4) void newMessages(MessageDescriptor[] messages);
    
}