package io.aether.api.chatdsl;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public interface ServiceServerApi  {
    FastMetaApi<ServiceServerApi,ServiceServerApiRemote> META=new FastMetaApi<>() {
        public void makeLocal(FastFutureContext serializeContextVar_55, DataIn in_, ServiceServerApi localApi) {
            while(in_.isReadable()) {
                byte commandId = in_.readByte();
                switch(commandId)  {
                    case 0: {
                        var requestId_56 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_55,in_);
                        var futureRec_57 = serializeContextVar_55.getFuture(requestId_56);
                        if(futureRec_57 != null) futureRec_57.onDone(in_);
                        break;
                        
                    }
                    case 1: {
                        var requestId_58 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_55,in_);
                        var futureRec_59 = serializeContextVar_55.getFuture(requestId_58);
                        if(futureRec_59 != null) futureRec_59.onError(in_);
                        break;
                        
                    }
                    case 3:  {
                        int requestId_60 = in_.readInt();
                        String name_61;
                        byte[] stringData_62;
                        var arraySize_63 = DeserializerPackNumber.INSTANCE.put(in_).intValue();
                        stringData_62=new byte[arraySize_63];
                        in_.read(stringData_62);
                        name_61=new String(stringData_62);
                        String[] argsNames_64 = new String[] {
                            "name"
                        };
                        Object[] argsValues_65 = new Object[] {
                            name_61
                        };
                        serializeContextVar_55.invokeLocalMethodBefore("registration", argsNames_64, argsValues_65);
                        serializeContextVar_55.regLocalFuture();
                        var result_66 = localApi.registration(name_61);
                        serializeContextVar_55.invokeLocalMethodAfter("registration", result_66, argsNames_64, argsValues_65);
                        result_66.to(()-> {
                            var data_67 = new DataInOut();
                            serializeContextVar_55.sendResultToRemote(requestId_60);
                            
                        }
                        );
                        break;
                        
                    }
                    case 4:  {
                        String msg_69;
                        byte[] stringData_70;
                        var arraySize_71 = DeserializerPackNumber.INSTANCE.put(in_).intValue();
                        stringData_70=new byte[arraySize_71];
                        in_.read(stringData_70);
                        msg_69=new String(stringData_70);
                        String[] argsNames_72 = new String[] {
                            "msg"
                        };
                        Object[] argsValues_73 = new Object[] {
                            msg_69
                        };
                        serializeContextVar_55.invokeLocalMethodBefore("sendMessage", argsNames_72, argsValues_73);
                        localApi.sendMessage(msg_69);
                        serializeContextVar_55.invokeLocalMethodAfter("sendMessage", null, argsNames_72, argsValues_73);
                        break;
                        
                    }
                    default: throw new IllegalArgumentException("Unknown command ID: " + commandId);
                    
                }
                
            }
            
        }
        public ServiceServerApiRemote makeRemote(FastFutureContext localApi_75) {
            return new ServiceServerApiRemote() {
                @Override public void flush(AFuture sendFuture) {
                    localApi_75.flush(sendFuture);
                    
                }
                public io.aether.net.fastMeta.FastFutureContext getFastMetaContext() {
                    return localApi_75;
                    
                }
                @Override public @Command(3) AFuture registration(String name) {
                    var dataOut_76 = new DataInOut();
                    dataOut_76.writeByte(3);
                    String[] argsNames_78 = new String[] {
                        "name"
                    };
                    Object[] argsValues_79 = new Object[] {
                        name
                    };
                    var result_77 = AFuture.make();
                    localApi_75.invokeRemoteMethodAfter("registration", result_77, argsNames_78, argsValues_79);
                    var requestId_80 = localApi_75.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_77.done();
                            
                        }
                        public void onError(DataIn in) {
                            result_77.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_76.writeInt(requestId_80);
                    var stringData_81=name.getBytes();
                    SerializerPackNumber.INSTANCE.put(dataOut_76,stringData_81.length);
                    dataOut_76.write(stringData_81);
                    localApi_75.sendToRemote(dataOut_76.toArray());
                    return result_77;
                    
                }
                @Override public @Command(4) void sendMessage(String msg) {
                    var dataOut_82 = new DataInOut();
                    dataOut_82.writeByte(4);
                    String[] argsNames_84 = new String[] {
                        "msg"
                    };
                    Object[] argsValues_85 = new Object[] {
                        msg
                    };
                    localApi_75.invokeRemoteMethodAfter("sendMessage", null, argsNames_84, argsValues_85);
                    var stringData_86=msg.getBytes();
                    SerializerPackNumber.INSTANCE.put(dataOut_82,stringData_86.length);
                    dataOut_82.write(stringData_86);
                    localApi_75.sendToRemote(dataOut_82.toArray());
                    
                }
                
            };
            
        }
        
    };
    @Command(3) AFuture registration(String name);
    @Command(4) void sendMessage(String msg);
    
}