package io.aether.api.chatdsl;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class UserDescriptor implements io.aether.utils.ToString {
    public static final FastMetaType<UserDescriptor> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_0, UserDescriptor obj_1, DataOut out_2) {
            FastMeta.META_UUID.serialize(serializeContextVar_0,obj_1.uid,out_2);
            var stringData_4=obj_1.name.getBytes();
            SerializerPackNumber.INSTANCE.put(out_2,stringData_4.length);
            out_2.write(stringData_4);
            
        }
        @Override public UserDescriptor deserialize(FastFutureContext serializeContextVar_0, DataIn in_3) {
            UUID uid_5;
            String name_6;
            uid_5=FastMeta.META_UUID.deserialize(serializeContextVar_0,in_3);
            byte[] stringData_7;
            var arraySize_8 = DeserializerPackNumber.INSTANCE.put(in_3).intValue();
            stringData_7=new byte[arraySize_8];
            in_3.read(stringData_7);
            name_6=new String(stringData_7);
            return new UserDescriptor(uid_5,name_6);
            
        }
        
    };
    public static final FastMetaType<UserDescriptor> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_9, UserDescriptor obj_10, DataOut out_11) {
            UserDescriptor.META_BODY.serialize(serializeContextVar_9, obj_10, out_11);
            
        }
        @Override public UserDescriptor deserialize(FastFutureContext serializeContextVar_9, DataIn in_12) {
            return UserDescriptor.META_BODY.deserialize(serializeContextVar_9, in_12);
            
        }
        
    };
    protected final UUID uid;
    protected final String name;
    public UserDescriptor(UUID uid, String name) {
        this.uid = uid;
        this.name = name;
        
    }
    public UUID getUid() {
        return this.uid;
        
    }
    public String getName() {
        return this.name;
        
    }
    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || !(o instanceof UserDescriptor)) return false;
        UserDescriptor that = (UserDescriptor) o;
        return java.util.Objects.equals(this.uid, that.uid) && java.util.Objects.equals(this.name, that.name);
        
    }
    @Override public int hashCode() {
        return java.util.Objects.hash(this.uid, this.name);
        
    }
    @Override public String toString() {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb) {
        sb.add("UserDescriptor(");
        sb.add("uid:");
        sb.add(this.uid);
        sb.add(", ");
        sb.add("name:");
        sb.add(this.name);
        sb.add(')');
        
    }
    
}