package io.aether.examples.plainChat;

import io.aether.api.chatdsl.MessageDescriptor;
import io.aether.logger.Log;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class PlainChatTest {
    public final List<URI> registrationUri = new ArrayList<>();

    {
        registrationUri.add(URI.create("tcp://registration.aethernet.io:9010"));
    }

    public AFuture start() {
        ChatService chatService = new ChatService(registrationUri);
        ChatClient chatClient1 = new ChatClient(chatService.aether.getUid(), registrationUri, "client1");
        ChatClient chatClient2 = new ChatClient(chatService.aether.getUid(), registrationUri, "client2");
        Log.info("Client was started");
        AFuture res = AFuture.make();
        AFuture.all(chatClient1.aether.startFuture, chatClient2.aether.startFuture).to(() -> {
            var future = ARFuture.<MessageDescriptor>make();
            chatClient2.onMessage.add(m -> {
                Log.info("receive message: $msg", "msg", m);
                future.tryDone(m);
            });
            chatClient1.sendMessage("test");
            future.to((m) -> Log.info("The message has been received: $msg", "msg", m));
            future.timeoutError(10, "timeout receive message exception");
            future.to(res);
        });
        return res;
    }
}
